/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.recipe.InfusionRecipe;
import net.tslat.aoa3.content.recipe.ToolInteractionRecipe;
import net.tslat.aoa3.content.recipe.TrophyRecipe;
import net.tslat.aoa3.content.recipe.UpgradeKitRecipe;

public final class AoARecipes {
    public static final RecipeTypeContainer<UpgradeKitRecipe> UPGRADE_KIT = AoARecipes.registerRecipeType("upgrade_kit", UpgradeKitRecipe.Factory::new);
    public static final RecipeTypeContainer<InfusionRecipe> INFUSION = AoARecipes.registerRecipeType("infusion", InfusionRecipe.Factory::new);
    public static final RecipeTypeContainer<TrophyRecipe> TROPHY = AoARecipes.registerRecipeType("trophy", TrophyRecipe.Factory::new);
    public static final RecipeTypeContainer<ToolInteractionRecipe> TOOL_INTERACTION = AoARecipes.registerRecipeType("tool_interaction", ToolInteractionRecipe.Factory::new);

    public static void init() {
    }

    private static <T extends Recipe<I>, I extends Container> RecipeTypeContainer<T> registerRecipeType(final String id, Supplier<RecipeSerializer<T>> serializer) {
        return new RecipeTypeContainer<T>(AoARegistries.RECIPE_TYPES.register(id, () -> new RecipeType<T>(){

            public String toString() {
                return AdventOfAscension.id(id).toString();
            }
        }), AoARegistries.RECIPE_SERIALIZERS.register(id, serializer));
    }

    public record RecipeTypeContainer<T extends Recipe<?>>(RegistryObject<RecipeType<T>> type, RegistryObject<RecipeSerializer<T>> serializer) {
    }
}

