/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.log;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.tslat.aoa3.util.BlockUtil;

public class LogBlock
extends RotatedPillarBlock {
    private final Supplier<BlockState> strippedBlock;

    public LogBlock(MaterialColor mapColour) {
        this(mapColour, mapColour);
    }

    public LogBlock(MaterialColor mapColour, Supplier<Block> strippedBlock) {
        this(mapColour, mapColour, strippedBlock);
    }

    public LogBlock(MaterialColor mapColour, MaterialColor logEndMapColour) {
        this(mapColour, logEndMapColour, null);
    }

    public LogBlock(MaterialColor mapColour, MaterialColor logEndMapColour, Supplier<Block> strippedBlock) {
        super(new BlockUtil.CompactProperties(Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? logEndMapColour : mapColour).stats(2.0f).get());
        this.strippedBlock = strippedBlock == null ? null : () -> ((Block)strippedBlock.get()).m_49966_();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (this.strippedBlock == null) {
            return super.getToolModifiedState(state, context, toolAction, simulate);
        }
        return ToolActions.AXE_STRIP.equals(toolAction) ? this.strippedBlock.get() : null;
    }
}

