/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.tileentity;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.util.LocaleUtil;

public class TrophyTileEntity
extends BlockEntity
implements Nameable {
    @Nullable
    private Entity cachedEntity = null;
    @Nullable
    private String entityId = null;
    private boolean isOriginal = true;
    private Block trophyBlock = null;
    private float mobRotation;
    private float prevMobRotation;
    public double hoverStep;

    public TrophyTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AoABlockEntities.TROPHY.get(), pos, state);
    }

    public void setEntity(String entityId, boolean isEgg) {
        this.entityId = entityId;
        this.cachedEntity = null;
        this.isOriginal = !isEgg;
    }

    public static void doClientTick(Level level, BlockPos pos, BlockState state, TrophyTileEntity blockEntity) {
        blockEntity.prevMobRotation = blockEntity.mobRotation;
        blockEntity.mobRotation = (blockEntity.mobRotation + 0.05f) % 360.0f;
        if (blockEntity.trophyBlock == null && level != null) {
            blockEntity.trophyBlock = level.m_8055_(pos).m_60734_();
        }
    }

    public float getMobRotation() {
        return this.mobRotation;
    }

    public float getPrevMobRotation() {
        return this.prevMobRotation;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.entityId != null) {
            tag.m_128359_("EntityID", this.entityId);
            tag.m_128379_("OriginalTrophy", this.isOriginal);
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128425_("EntityID", 8)) {
            this.entityId = tag.m_128461_("EntityID");
            this.isOriginal = tag.m_128471_("OriginalTrophy");
        }
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.entityId != null) {
            compound.m_128359_("EntityID", this.entityId);
            compound.m_128379_("OriginalTrophy", this.isOriginal);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("EntityID")) {
            this.entityId = compound.m_128461_("EntityID");
            this.isOriginal = compound.m_128471_("OriginalTrophy");
        }
    }

    @Nullable
    public Entity getCachedEntity() {
        if (this.cachedEntity == null && this.entityId != null) {
            CompoundTag entityNBT = new CompoundTag();
            entityNBT.m_128359_("id", this.entityId);
            this.cachedEntity = EntityType.m_20645_((CompoundTag)entityNBT, (Level)this.m_58904_(), Function.identity());
            if (this.cachedEntity == null) {
                entityNBT = new CompoundTag();
                this.entityId = "minecraft:end_crystal";
                entityNBT.m_128359_("id", this.entityId);
                this.cachedEntity = EntityType.m_20645_((CompoundTag)entityNBT, (Level)this.m_58904_(), Function.identity());
            }
            if (this.cachedEntity != null) {
                this.cachedEntity.f_19797_ = 1;
            }
        }
        return this.cachedEntity;
    }

    public Component m_7755_() {
        if (this.trophyBlock == null || this.entityId == null) {
            return LocaleUtil.getLocaleMessage("block.aoa3.trophy");
        }
        if (this.getCachedEntity() == null) {
            return LocaleUtil.getLocaleMessage("block.aoa3.trophy");
        }
        if (this.trophyBlock == AoABlocks.TROPHY.get()) {
            return LocaleUtil.getLocaleMessage("block.aoa3.trophy.desc", this.cachedEntity.m_7755_());
        }
        if (this.trophyBlock == AoABlocks.GOLD_TROPHY.get()) {
            return LocaleUtil.getLocaleMessage("block.aoa3.gold_trophy.desc", this.cachedEntity.m_7755_());
        }
        if (this.trophyBlock == AoABlocks.ORNATE_TROPHY.get()) {
            return LocaleUtil.getLocaleMessage("block.aoa3.ornate_trophy.desc", this.cachedEntity.m_7755_());
        }
        return LocaleUtil.getLocaleMessage("block.aoa3.trophy");
    }

    public boolean m_8077_() {
        return this.trophyBlock != null && this.entityId != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.m_7755_();
    }
}

