/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.content.entity.base.LavaMobEntity;

public abstract class AbstractLavaFishEntity
extends LavaMobEntity {
    public AbstractLavaFishEntity(EntityType<? extends AbstractLavaFishEntity> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new MoveHelperController(this);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.65f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0);
    }

    public static boolean checkFishSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor world, MobSpawnType reason, BlockPos position, Random rand) {
        return world.m_8055_(position).m_60713_(Blocks.f_49991_) && world.m_8055_(position.m_7494_()).m_60713_(Blocks.f_49991_);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_8077_();
    }

    public int m_5792_() {
        return 8;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal(this));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6142_() && this.m_20077_()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_8107_() {
        if (!this.m_20077_() && this.f_19861_ && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.f_19861_ = false;
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    protected boolean canRandomSwim() {
        return true;
    }

    protected abstract SoundEvent getFlopSound();

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
    }

    static class MoveHelperController
    extends MoveControl {
        private final AbstractLavaFishEntity fish;

        MoveHelperController(AbstractLavaFishEntity fish) {
            super((Mob)fish);
            this.fish = fish;
        }

        public void m_8126_() {
            if (this.fish.m_204029_(FluidTags.f_13132_)) {
                this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.fish.m_21573_().m_26571_()) {
                float moveSpeed = (float)(this.f_24978_ * this.fish.m_21133_(Attributes.f_22279_));
                this.fish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.fish.m_6113_(), (float)moveSpeed));
                double distX = this.f_24975_ - this.fish.m_20185_();
                double distY = this.f_24976_ - this.fish.m_20186_();
                double distZ = this.f_24977_ - this.fish.m_20189_();
                if (distY != 0.0) {
                    double dist = Math.sqrt(distX * distX + distY * distY + distZ * distZ);
                    this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, (double)this.fish.m_6113_() * (distY / dist) * 0.1, 0.0));
                }
                if (distX != 0.0 || distZ != 0.0) {
                    float rotation = (float)(Mth.m_14136_((double)distZ, (double)distX) * 57.2957763671875) - 90.0f;
                    this.fish.m_146922_(this.m_24991_(this.fish.m_146908_(), rotation, 90.0f));
                    this.fish.f_20883_ = this.fish.m_146908_();
                }
            } else {
                this.fish.m_7910_(0.0f);
            }
        }
    }

    static class FloatGoal
    extends RandomSwimmingGoal {
        private final AbstractLavaFishEntity fish;

        public FloatGoal(AbstractLavaFishEntity fish) {
            super((PathfinderMob)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean m_8036_() {
            return this.fish.canRandomSwim() && super.m_8036_();
        }
    }
}

