/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;
import software.bernie.aoa3.geckolib3.core.manager.AnimationFactory;

public abstract class AoAAmbientNPC
extends PathfinderMob
implements Npc,
IAnimatable {
    private final AnimationFactory animationFactory = new AnimationFactory(this);
    private final HashMap<String, Integer> animationStates = new HashMap(1);

    public AoAAmbientNPC(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AoAMeleeMob.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    @Nullable
    protected abstract String getInteractMessage(ItemStack var1);

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        return this.checkSpawnChance(reason) && this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.m_8055_(this.m_142538_().m_7495_()));
    }

    protected boolean canSpawnAt(MobSpawnType reason, BlockState blockState) {
        return reason == MobSpawnType.SPAWNER || blockState.m_60643_((BlockGetter)this.f_19853_, this.m_142538_(), this.m_6095_());
    }

    protected int getSpawnChanceFactor() {
        return 1;
    }

    private boolean checkSpawnChance(MobSpawnType reason) {
        return EntityUtil.isNaturalSpawnReason(reason) || this.getSpawnChanceFactor() <= 1 || this.f_19796_.nextInt(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean isValidLightLevel(MobSpawnType reason) {
        if (!WorldUtil.isWorld(this.f_19853_, AoADimensions.OVERWORLD.key)) {
            return true;
        }
        BlockPos blockpos = new BlockPos(this.m_20185_(), this.m_142469_().f_82289_, this.m_20189_());
        if (this.f_19853_.m_45517_(LightLayer.SKY, blockpos) > this.f_19796_.nextInt(32)) {
            return true;
        }
        int light = this.f_19853_.m_46470_() ? this.f_19853_.m_46849_(blockpos, 10) : (int)this.f_19853_.m_46863_(blockpos) * 15;
        return light > this.f_19796_.nextInt(8);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        String msg;
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41720_() == Items.f_42656_) {
            heldStack.m_41647_(player, (LivingEntity)this, hand);
            return InteractionResult.SUCCESS;
        }
        if (!this.f_19853_.f_46443_ && hand == InteractionHand.MAIN_HAND && (msg = this.getInteractMessage(heldStack)) != null) {
            PlayerUtil.notifyPlayer(player, (Component)new TranslatableComponent(msg).m_130940_(ChatFormatting.GRAY));
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void registerControllers(AnimationData data) {
    }

    @Override
    public AnimationFactory getFactory() {
        return this.animationFactory;
    }
}

