/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.AoABrainMemories;
import net.tslat.aoa3.util.PlayerUtil;

public class BlockIncomingProjectileTask
extends Behavior<Mob> {
    private final boolean equipShieldIfUnequipped;
    private InteractionHand hand = null;
    private boolean equipShield = false;
    private long equipTime;

    public BlockIncomingProjectileTask(boolean equipShieldIfUnequipped) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)AoABrainMemories.INCOMING_PROJECTILES.get()), (Object)MemoryStatus.VALUE_PRESENT));
        this.equipShieldIfUnequipped = equipShieldIfUnequipped;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Mob owner) {
        Item mainHandItem = owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        Item offHandItem = owner.m_21120_(InteractionHand.OFF_HAND).m_41720_();
        this.hand = InteractionHand.MAIN_HAND;
        Projectile projectile = (Projectile)((List)owner.m_6274_().m_21952_((MemoryModuleType)AoABrainMemories.INCOMING_PROJECTILES.get()).get()).get(0);
        if (!owner.m_142582_((Entity)projectile)) {
            return false;
        }
        if (mainHandItem instanceof ShieldItem) {
            return true;
        }
        this.hand = InteractionHand.OFF_HAND;
        if (offHandItem instanceof ShieldItem) {
            return true;
        }
        if (offHandItem == Items.f_41852_ && this.equipShieldIfUnequipped) {
            this.equipShield = true;
            return true;
        }
        return false;
    }

    protected void start(ServerLevel pLevel, Mob owner, long pGameTime) {
        if (this.equipShield) {
            owner.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42740_));
            this.equipShield = false;
        }
        this.equipTime = pGameTime;
        owner.m_6672_(this.hand);
        Entity faceTarget = this.getEntityFocus(owner);
    }

    protected void tick(ServerLevel level, Mob owner, long gameTime) {
        if (gameTime - this.equipTime <= 10L) {
            return;
        }
        if (!owner.m_6274_().m_21952_((MemoryModuleType)AoABrainMemories.INCOMING_PROJECTILES.get()).isPresent()) {
            this.m_22562_(level, (LivingEntity)owner, gameTime);
        }
    }

    protected boolean canStillUse(ServerLevel pLevel, Mob owner, long gameTime) {
        return gameTime - this.equipTime <= 10L || owner.m_6274_().m_21952_((MemoryModuleType)AoABrainMemories.INCOMING_PROJECTILES.get()).isPresent();
    }

    protected void stop(ServerLevel pLevel, Mob owner, long pGameTime) {
        owner.m_5810_();
    }

    @Nullable
    private Entity getEntityFocus(Mob owner) {
        Brain brain = owner.m_6274_();
        if (!brain.m_21874_((MemoryModuleType)AoABrainMemories.INCOMING_PROJECTILES.get())) {
            return null;
        }
        List projectiles = (List)brain.m_21952_((MemoryModuleType)AoABrainMemories.INCOMING_PROJECTILES.get()).get();
        if (projectiles.isEmpty()) {
            return null;
        }
        Projectile projectile = (Projectile)projectiles.get(0);
        Player target = PlayerUtil.getPlayerOrOwnerIfApplicable((Entity)projectile);
        return target != null ? target : projectile;
    }
}

