/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LootUtil;

public class LottoTotemEntity
extends Entity {
    private UUID winnerUUID = null;
    private UUID ownerUUID = null;

    public LottoTotemEntity(Level world, BlockPos pos, UUID winnerUUID, UUID ownerUUID) {
        this((EntityType<? extends Entity>)((EntityType)AoAMiscEntities.LOTTO_TOTEM.get()), world);
        this.winnerUUID = winnerUUID;
        this.ownerUUID = ownerUUID;
        VoxelShape floorShape = world.m_8055_(pos).m_60808_((BlockGetter)world, pos);
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + floorShape.m_83297_(Direction.Axis.Y), (double)pos.m_123343_() + 0.5);
    }

    public LottoTotemEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
        this.f_19850_ = true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return this.f_19797_ >= 12000 || !this.f_19853_.f_46443_ && (this.ownerUUID == null || player.m_142081_().equals(this.ownerUUID)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean m_6072_() {
        return false;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (this.m_6084_() && (this.ownerUUID == null || player.m_142081_().equals(this.ownerUUID))) {
            if (player instanceof ServerPlayer) {
                if (this.winnerUUID != null && this.winnerUUID.equals(this.m_142081_())) {
                    for (ItemStack stack : LootUtil.generateLoot((ServerLevel)this.f_19853_, new ResourceLocation("aoa3", "misc/lotto_totem"), LootUtil.getGiftContext((ServerLevel)this.f_19853_, this.m_20182_(), 5.0f, (Entity)player))) {
                        ItemEntity drop = this.m_5552_(stack, 0.0f);
                        if (drop != null) {
                            drop.m_32047_(player.m_142081_());
                        }
                        AdvancementUtil.completeAdvancement((ServerPlayer)player, new ResourceLocation("aoa3", "overworld/winner_winner"), "lotto_win");
                    }
                    ItemEntity drop = this.m_5552_(new ItemStack((ItemLike)AoABlocks.LOTTO_BANNER.get()), 0.0f);
                    if (drop != null) {
                        drop.m_32047_(player.m_142081_());
                    }
                    this.f_19853_.m_5594_(null, this.m_142538_(), (SoundEvent)AoASounds.LOTTO_WIN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                for (LottoTotemEntity totem : this.f_19853_.m_45976_(LottoTotemEntity.class, new AABB(this.m_142538_()).m_82400_(2.0))) {
                    totem.m_146870_();
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.f_19853_.f_46443_ && !this.m_6084_()) {
            for (int i = 0; i < 3; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag compound) {
        if (compound.m_128403_("WinningUUID")) {
            this.winnerUUID = compound.m_128342_("WinningUUID");
        }
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (this.winnerUUID != null) {
            compound.m_128362_("WinningUUID", this.winnerUUID);
        }
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return source != DamageSource.f_19317_;
    }

    public void m_8119_() {
        this.m_6075_();
    }

    public void m_6075_() {
        this.f_19853_.m_46473_().m_6180_("entityBaseTick");
        if (this.m_20186_() < -64.0) {
            this.m_6088_();
        }
        this.f_19853_.m_46473_().m_7238_();
    }
}

