/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.creeponia;

import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.WorldUtil;

public abstract class AoACreeponiaCreeper
extends AoAMeleeMob {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(AoACreeponiaCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.m_135353_(AoACreeponiaCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.m_135353_(AoACreeponiaCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int fuseTime = 30;
    protected int lastActiveTime;
    protected int timeSinceIgnited;
    private float swimAnimation;
    private float lastSwimAnimation;
    private int explosionRadius = 3;

    public AoACreeponiaCreeper(EntityType<? extends AoACreeponiaCreeper> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CustomCreeperSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, TamableAnimal.class, 10, true, false, entity -> entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21824_()));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)-1);
        this.f_19804_.m_135372_(POWERED, (Object)false);
        this.f_19804_.m_135372_(IGNITED, (Object)false);
    }

    public abstract float getExplosionStrength();

    @Override
    protected void onAttack(Entity target) {
    }

    @Override
    protected void onHit(DamageSource source, float amount) {
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11836_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState block) {
    }

    public int getCreeperState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setCreeperState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public void m_8038_(ServerLevel world, LightningBolt lightningBolt) {
        super.m_8038_(world, lightningBolt);
        this.f_19804_.m_135381_(POWERED, (Object)true);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42409_) {
            this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)player, p_213625_1_ -> p_213625_1_.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int creeperState;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((creeperState = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += creeperState;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        if (!ForgeHooks.onLivingUpdate((LivingEntity)this)) {
            if (!this.f_19853_.f_46443_) {
                this.m_20115_(6, this.m_142038_());
            }
            this.m_6075_();
            this.lastSwimAnimation = this.swimAnimation;
            this.swimAnimation = this.m_6067_() ? Math.min(1.0f, this.swimAnimation + 0.09f) : Math.max(0.0f, this.swimAnimation - 0.09f);
            if (!this.f_19853_.f_46443_) {
                int beeStings;
                int arrowCount = this.m_21234_();
                if (arrowCount > 0) {
                    if (this.f_20914_ <= 0) {
                        this.f_20914_ = 20 * (30 - arrowCount);
                    }
                    --this.f_20914_;
                    if (this.f_20914_ <= 0) {
                        this.m_21317_(arrowCount - 1);
                    }
                }
                if ((beeStings = this.m_21235_()) > 0) {
                    if (this.f_20915_ <= 0) {
                        this.f_20915_ = 20 * (30 - beeStings);
                    }
                    --this.f_20915_;
                    if (this.f_20915_ <= 0) {
                        this.m_21321_(beeStings - 1);
                    }
                }
                if (this.f_19797_ % 20 == 0) {
                    this.m_21231_().m_19296_();
                }
                if (!this.m_142038_()) {
                    boolean glowing = this.m_21023_(MobEffects.f_19619_);
                    if (this.m_20291_(6) != glowing) {
                        this.m_20115_(6, glowing);
                    }
                }
            }
            this.m_8107_();
            double diffX = this.m_20185_() - this.f_19854_;
            double diffZ = this.m_20189_() - this.f_19856_;
            float movementDiff = (float)(diffX * diffX + diffZ * diffZ);
            float direction = this.f_20883_;
            float distanceMoved = 0.0f;
            this.f_20892_ = this.f_20893_;
            float moveSpeedBase = 0.0f;
            if (movementDiff > 0.0025000002f) {
                moveSpeedBase = 1.0f;
                distanceMoved = (float)Math.sqrt(movementDiff) * 3.0f;
                float f = (float)Mth.m_14136_((double)diffZ, (double)diffX) * 57.295776f - 90.0f;
                float f1 = Mth.m_14154_((float)(Mth.m_14177_((float)this.m_146908_()) - f));
                direction = 95.0f < f1 && f1 < 265.0f ? f - 180.0f : f;
            }
            if (this.f_20921_ > 0.0f) {
                direction = this.m_146908_();
            }
            if (!this.f_19861_) {
                moveSpeedBase = 0.0f;
            }
            this.f_20893_ += (moveSpeedBase - this.f_20893_) * 0.3f;
            this.f_19853_.m_46473_().m_6180_("headTurn");
            distanceMoved = this.m_5632_(direction, distanceMoved);
            this.f_19853_.m_46473_().m_7238_();
            this.f_19853_.m_46473_().m_6180_("rangeChecks");
            while (this.m_146908_() - this.f_19859_ < -180.0f) {
                this.f_19859_ -= 360.0f;
            }
            while (this.m_146908_() - this.f_19859_ >= 180.0f) {
                this.f_19859_ += 360.0f;
            }
            while (this.f_20883_ - this.f_20884_ < -180.0f) {
                this.f_20884_ -= 360.0f;
            }
            while (this.f_20883_ - this.f_20884_ >= 180.0f) {
                this.f_20884_ += 360.0f;
            }
            while (this.m_146909_() - this.f_19860_ < -180.0f) {
                this.f_19860_ -= 360.0f;
            }
            while (this.m_146909_() - this.f_19860_ >= 180.0f) {
                this.f_19860_ += 360.0f;
            }
            while (this.f_20885_ - this.f_20886_ < -180.0f) {
                this.f_20886_ -= 360.0f;
            }
            while (this.f_20885_ - this.f_20886_ >= 180.0f) {
                this.f_20886_ += 360.0f;
            }
            this.f_19853_.m_46473_().m_7238_();
            this.f_20894_ += distanceMoved;
            this.f_20937_ = this.m_21255_() ? ++this.f_20937_ : 0;
            if (this.m_5803_()) {
                this.m_146926_(0.0f);
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.m_6119_();
            if (this.f_19797_ % 5 == 0) {
                this.m_8022_();
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (((Boolean)this.f_19804_.m_135370_(POWERED)).booleanValue()) {
            compound.m_128379_("powered", true);
        }
        compound.m_128376_("Fuse", (short)this.fuseTime);
        compound.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        compound.m_128379_("ignited", this.hasIgnited());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(POWERED, (Object)compound.m_128471_("powered"));
        if (compound.m_128425_("Fuse", 99)) {
            this.fuseTime = compound.m_128448_("Fuse");
        }
        if (compound.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compound.m_128445_("ExplosionRadius");
        }
        if (compound.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        boolean success = super.m_142535_(distance, damageMultiplier, damageSource);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return success;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_20998_(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastSwimAnimation, (float)this.swimAnimation);
    }

    public boolean hasIgnited() {
        return (Boolean)this.f_19804_.m_135370_(IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(IGNITED, (Object)true);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(POWERED);
    }

    protected void explode() {
        if (!this.f_19853_.f_46443_) {
            WorldUtil.createExplosion((Entity)this, this.f_19853_, this.getExplosionStrength() * (this.isCharged() ? 2.0f : 1.0f));
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    protected void spawnLingeringCloud() {
        Collection activeEffects = this.m_21220_();
        if (!activeEffects.isEmpty()) {
            AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            cloud.m_19712_(2.5f);
            cloud.m_19732_(-0.5f);
            cloud.m_19740_(10);
            cloud.m_19734_(cloud.m_19748_() / 2);
            cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
            for (MobEffectInstance effect : activeEffects) {
                cloud.m_19716_(new MobEffectInstance(effect));
            }
            this.f_19853_.m_7967_((Entity)cloud);
        }
    }

    public static class CustomCreeperSwellGoal
    extends Goal {
        private final AoACreeponiaCreeper swellingCreeper;
        private LivingEntity target;

        public CustomCreeperSwellGoal(AoACreeponiaCreeper entity) {
            this.swellingCreeper = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity target = this.swellingCreeper.m_5448_();
            return this.swellingCreeper.getCreeperState() > 0 || target != null && this.swellingCreeper.m_20280_((Entity)target) < 9.0;
        }

        public void m_8056_() {
            this.swellingCreeper.m_21573_().m_26573_();
            this.target = this.swellingCreeper.m_5448_();
        }

        public void m_8041_() {
            this.target = null;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.swellingCreeper.setCreeperState(-1);
            } else if (this.swellingCreeper.m_20280_((Entity)this.target) > 49.0) {
                this.swellingCreeper.setCreeperState(-1);
            } else if (!this.swellingCreeper.m_21574_().m_148306_((Entity)this.target)) {
                this.swellingCreeper.setCreeperState(-1);
            } else {
                this.swellingCreeper.setCreeperState(1);
            }
        }
    }
}

