/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld.bigday;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.ai.mob.MultiTypeAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedRangedAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.RandomUtil;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;

public class IceGiantEntity
extends AoAMeleeMob
implements RangedAttackMob {
    private int lastAttackTime = 0;

    public IceGiantEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.f_19793_ = 1.5f;
    }

    @Override
    protected void m_8099_() {
        TelegraphedMeleeAttackGoal<IceGiantEntity> meleeGoal = new TelegraphedMeleeAttackGoal<IceGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.m_21304_());
        TelegraphedRangedAttackGoal<IceGiantEntity> rangedGoal = new TelegraphedRangedAttackGoal<IceGiantEntity>(this).attackFrequency(0, 1).moveSpeedMod(0.0f).windUpTime(1);
        this.f_21345_.m_25352_(1, (Goal)new MultiTypeAttackGoal((Object2IntFunction<Goal>)((Object2IntFunction)currentGoal -> {
            LivingEntity target = this.m_5448_();
            if (target == null) {
                return 0;
            }
            if (this.f_19797_ - this.lastAttackTime > 120) {
                return this.m_20280_((Entity)target) < 16.0 ? 0 : 1;
            }
            if (this.m_20280_((Entity)target) > 100.0 && !target.m_146890_()) {
                return 1;
            }
            return this.m_21573_().m_6570_((Entity)target, 0) == null ? 1 : 0;
        }), meleeGoal, rangedGoal));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.6f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.65625f;
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_GIANT_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_GIANT_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_VERY_HEAVY_STEP.get();
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8024_() {
        LivingEntity target;
        super.m_8024_();
        if (this.m_5842_()) {
            ServerParticlePacket packet = new ServerParticlePacket();
            AABB boundingBox = this.m_142469_();
            double width = boundingBox.f_82291_ - boundingBox.f_82288_;
            double depth = boundingBox.f_82293_ - boundingBox.f_82290_;
            double height = boundingBox.f_82292_ - boundingBox.f_82289_;
            int i = 0;
            while ((double)i < 3.0 + 10.0 * width * depth * height) {
                packet.particle(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.FREEZING_SNOWFLAKE.get()), 0.3f, 3.0f, 0), boundingBox.f_82288_ + RandomUtil.randomValueUpTo(width), boundingBox.f_82289_ + RandomUtil.randomValueUpTo(height), boundingBox.f_82290_ + RandomUtil.randomValueUpTo(depth), RandomUtil.randomScaledGaussianValue(0.05), 0.0, RandomUtil.randomScaledGaussianValue(0.05));
                ++i;
            }
            AoAPackets.messageNearbyPlayers(packet, (ServerLevel)this.f_19853_, this.m_20182_(), 10.0);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if ((target = this.m_5448_()) != null && target.m_146890_()) {
            this.lastAttackTime = this.f_19797_;
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    protected void onAttack(Entity target) {
        this.lastAttackTime = this.f_19797_;
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericWalkController(this));
        animationData.addAnimationController(AoAAnimations.genericAttackController(this, AoAAnimations.ATTACK_SLAM));
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        double baseX = this.m_20185_();
        double baseY = this.m_20188_();
        double baseZ = this.m_20189_();
        ServerParticlePacket packet = new ServerParticlePacket(true);
        for (int i = 0; i < 5; ++i) {
            double x = baseX + RandomUtil.randomScaledGaussianValue(0.5);
            double y = baseY + RandomUtil.randomScaledGaussianValue(0.5);
            double z = baseZ + RandomUtil.randomScaledGaussianValue(0.5);
            double targetX = target.m_20185_() + RandomUtil.randomScaledGaussianValue(0.5);
            double targetY = target.m_20188_() + RandomUtil.randomScaledGaussianValue(0.5);
            double targetZ = target.m_20189_() + RandomUtil.randomScaledGaussianValue(0.5);
            packet.particle(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.FREEZING_SNOWFLAKE.get()), 0.4f, 12.0f, 0.0f, 0.0f, 0.0f, 0.0f, this.m_142049_()), baseX, baseY, baseZ, (targetX - x) * 0.1, (targetY - y) * 0.1, (targetZ - z) * 0.1);
        }
        AoAPackets.messageNearbyPlayers(packet, (ServerLevel)this.f_19853_, this.m_146892_(), 200.0);
    }
}

