/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld.bigday;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.EntityUtil;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;

public class WoodGiantEntity
extends AoAMeleeMob {
    public WoodGiantEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.f_19793_ = 1.5f;
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.875f;
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_GIANT_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_GIANT_HURT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_VERY_HEAVY_STEP.get();
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            EntityUtil.applyPotions(target, new EffectBuilder(MobEffects.f_19597_, 50).isAmbient());
            double resist = 1.0;
            AttributeInstance attrib = ((LivingEntity)target).m_21051_(Attributes.f_22278_);
            Vec3 motion = this.m_20184_();
            if (attrib != null) {
                resist -= attrib.m_22135_();
            }
            target.m_5997_(motion.m_7096_() * 21.0 * resist, motion.m_7098_() * 1.6 * resist, motion.m_7094_() * 21.0 * resist);
            target.f_19864_ = true;
        }
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericWalkController(this));
        animationData.addAnimationController(AoAAnimations.genericAttackController(this, AoAAnimations.ATTACK_SLAM));
    }
}

