/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.npc.ambient;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.content.entity.base.AoAAmbientNPC;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.PlayState;
import software.bernie.aoa3.geckolib3.core.controller.AnimationController;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;

public class DryadSpriteEntity
extends AoAAmbientNPC
implements IAnimatable {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(DryadSpriteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(DryadSpriteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> SUCCESS_TIMER = SynchedEntityData.m_135353_(DryadSpriteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public DryadSpriteEntity(EntityType<? extends DryadSpriteEntity> entityType, Level world) {
        super(entityType, world);
    }

    public DryadSpriteEntity(Player owner) {
        super((EntityType<? extends PathfinderMob>)((EntityType)AoANpcs.DRYAD_SPRITE.get()), owner.f_19853_);
        this.f_19804_.m_135381_(OWNER, Optional.of(owner.m_142081_()));
        this.f_19804_.m_135381_(VARIANT, (Object)RandomUtil.randomNumberUpTo(6));
        this.f_19804_.m_135381_(SUCCESS_TIMER, (Object)-1);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag nbt) {
        this.f_19804_.m_135381_(VARIANT, (Object)RandomUtil.randomNumberUpTo(6));
        return super.m_6518_(world, difficulty, reason, spawnData, nbt);
    }

    @Override
    @Nullable
    protected String getInteractMessage(ItemStack heldItem) {
        if (heldItem.m_41619_()) {
            return this.m_6095_().m_20675_() + ".interact.empty";
        }
        if (!ItemUtil.isHoe(heldItem.m_41720_())) {
            return this.m_6095_().m_20675_() + ".interact.incorrect";
        }
        return null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source != DamageSource.f_19317_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_6084_() && this.isOwner((Entity)player) && (Integer)this.m_20088_().m_135370_(SUCCESS_TIMER) == -1) {
            ItemStack heldStack = player.m_21120_(hand);
            if (!((Optional)this.m_20088_().m_135370_(OWNER)).isPresent()) {
                this.m_20088_().m_135381_(OWNER, Optional.of(player.m_142081_()));
            }
            if (ItemUtil.isHoe(heldStack.m_41720_())) {
                if (heldStack.m_41720_() == this.getVariant().getTool()) {
                    if (!this.f_19853_.m_5776_()) {
                        this.m_20088_().m_135381_(SUCCESS_TIMER, (Object)44);
                        player.m_5837_((ServerLevel)this.f_19853_, (LivingEntity)this);
                        this.f_21344_.m_26573_();
                        this.m_21557_(true);
                        this.m_20334_(0.0, 0.0, 0.0);
                    }
                } else {
                    this.m_146870_();
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AoASounds.ENTITY_DRYAD_SPRITE_UNHAPPY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    for (int i = 0; i < 20; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), RandomUtil.randomScaledGaussianValue(0.02), RandomUtil.randomScaledGaussianValue(0.02), RandomUtil.randomScaledGaussianValue(0.02));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OWNER, Optional.empty());
        this.f_19804_.m_135372_(SUCCESS_TIMER, (Object)-1);
    }

    public Variant getVariant() {
        return Variant.byNumber((Integer)this.f_19804_.m_135370_(VARIANT));
    }

    public void m_6043_() {
        super.m_6043_();
        if (!this.m_146910_() && this.f_19797_ > 100 && (Integer)this.m_20088_().m_135370_(SUCCESS_TIMER) == -1) {
            this.m_146870_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        int successTimer = (Integer)this.m_20088_().m_135370_(SUCCESS_TIMER);
        if (successTimer == -1) {
            return;
        }
        if (successTimer > 0) {
            this.m_20088_().m_135381_(SUCCESS_TIMER, (Object)(successTimer - 1));
            return;
        }
        for (int i = 0; i < 20; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), RandomUtil.randomScaledGaussianValue(0.02), RandomUtil.randomScaledGaussianValue(0.02), RandomUtil.randomScaledGaussianValue(0.02));
        }
        if (!this.f_19853_.m_5776_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AoASounds.ENTITY_DRYAD_SPRITE_HAPPY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            UUID ownerUuid = ((Optional)this.m_20088_().m_135370_(OWNER)).orElse(null);
            if (ownerUuid != null) {
                Player player = this.f_19853_.m_46003_(ownerUuid);
                this.m_21153_(0.0f);
                if (player != null) {
                    this.m_6668_(DamageSource.m_19344_((Player)player));
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController<DryadSpriteEntity>(this, "movement", 0.0f, event -> {
            if ((Integer)this.m_20088_().m_135370_(SUCCESS_TIMER) >= 0) {
                return PlayState.STOP;
            }
            if (event.isMoving()) {
                event.getController().setAnimation(AoAAnimations.WALK);
            } else {
                event.getController().setAnimation(AoAAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController<DryadSpriteEntity>(this, "collection", 0.0f, event -> {
            if ((Integer)this.m_20088_().m_135370_(SUCCESS_TIMER) >= 0) {
                event.getController().setAnimation(AoAAnimations.SUCCEED);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
    }

    public boolean isOwner(Entity entity) {
        return ((Optional)this.f_19804_.m_135370_(OWNER)).map(value -> value.equals(entity.m_142081_())).orElse(false);
    }

    public static enum Variant {
        WOOD(0, () -> Items.f_42424_),
        STONE(1, () -> Items.f_42429_),
        IRON(2, () -> Items.f_42387_),
        GOLD(3, () -> Items.f_42434_),
        DIAMOND(4, () -> Items.f_42392_),
        NETHERITE(5, () -> Items.f_42397_);

        private final int number;
        private final Supplier<Item> tool;

        private Variant(int number, Supplier<Item> tool) {
            this.number = number;
            this.tool = tool;
        }

        public int getNumber() {
            return this.number;
        }

        public Item getTool() {
            return this.tool.get();
        }

        public static Variant byNumber(int number) {
            return switch (number) {
                case 1 -> STONE;
                case 2 -> IRON;
                case 3 -> GOLD;
                case 4 -> DIAMOND;
                case 5 -> NETHERITE;
                default -> WOOD;
            };
        }
    }
}

