/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.cannon;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.WorldUtil;

public class MultiplyingGrenadeEntity
extends BaseBullet
implements HardProjectile {
    private int count;
    private LivingEntity shooter;
    private BaseGun gun;
    private InteractionHand hand;

    public MultiplyingGrenadeEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public MultiplyingGrenadeEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.MULTIPLYING_GRENADE.get()), world);
    }

    public MultiplyingGrenadeEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int counter) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.MULTIPLYING_GRENADE.get()), shooter, gun, hand, maxAge, 1.0f, 0);
        this.count = counter;
        this.shooter = shooter;
        this.gun = gun;
        this.hand = hand;
    }

    public MultiplyingGrenadeEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.MULTIPLYING_GRENADE.get()), world, x, y, z);
    }

    @Override
    public float m_7139_() {
        return 0.075f;
    }

    @Override
    public void doImpactEffect() {
        WorldUtil.createExplosion(this.m_37282_(), this.f_19853_, (Entity)this, 1.5f);
        if (!this.f_19853_.f_46443_ && this.getAge() < 10 && this.shooter instanceof Player && this.count < 5) {
            if (this.gun != null) {
                this.gun.doRecoil((ServerPlayer)this.shooter, new ItemStack((ItemLike)this.gun), this.hand);
            }
            this.f_19853_.m_7967_((Entity)new MultiplyingGrenadeEntity(this.shooter, this.gun, this.hand, 120, this.count + 1));
            this.f_19853_.m_6263_(null, this.shooter.m_20185_(), this.shooter.m_20186_(), this.shooter.m_20189_(), (SoundEvent)AoASounds.ITEM_MISSILE_MAKER_FIRE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.count < 5 && this.getAge() == 10 && this.shooter instanceof Player) {
            if (this.gun != null) {
                this.gun.doRecoil((ServerPlayer)this.shooter, new ItemStack((ItemLike)this.gun), this.hand);
            }
            this.f_19853_.m_7967_((Entity)new MultiplyingGrenadeEntity(this.shooter, this.gun, this.hand, 120, this.count + 1));
            this.f_19853_.m_6263_(null, this.shooter.m_20185_(), this.shooter.m_20186_(), this.shooter.m_20189_(), (SoundEvent)AoASounds.ITEM_MISSILE_MAKER_FIRE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

