/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.cannon;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.WorldUtil;

public class StickyCoolBombEntity
extends BaseBullet
implements HardProjectile {
    private BaseGun weapon;
    private LivingEntity shooter;
    private int ticksInGround = 0;

    public StickyCoolBombEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public StickyCoolBombEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.STICKY_COOL_BOMB.get()), world);
    }

    public StickyCoolBombEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.STICKY_COOL_BOMB.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
        this.weapon = gun;
        this.shooter = shooter;
    }

    public StickyCoolBombEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.STICKY_COOL_BOMB.get()), world, x, y, z);
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult rayTraceResult = (BlockHitResult)result;
            BlockState bl = this.f_19853_.m_8055_(rayTraceResult.m_82425_());
            double posX = rayTraceResult.m_82425_().m_123341_();
            double posY = rayTraceResult.m_82425_().m_123342_();
            double posZ = rayTraceResult.m_82425_().m_123343_();
            if (!bl.m_60767_().m_76334_()) {
                return;
            }
            ++this.ticksInGround;
            this.m_20334_(0.0, 0.0, 0.0);
            switch (rayTraceResult.m_82434_()) {
                case UP: {
                    posY += 1.0;
                    break;
                }
                case DOWN: {
                    posY -= 1.0;
                    break;
                }
                case SOUTH: {
                    posZ += 0.5;
                    break;
                }
                case NORTH: {
                    posZ -= 0.5;
                    break;
                }
                case EAST: {
                    posX += 0.5;
                    break;
                }
                case WEST: {
                    posX -= 0.5;
                    break;
                }
            }
            this.m_6034_(posX, posY, posZ);
        } else if (!this.f_19853_.m_5776_()) {
            if (result.m_6662_() == HitResult.Type.ENTITY) {
                Entity shooter = this.m_37282_();
                if (shooter instanceof LivingEntity) {
                    this.weapon.doImpactDamage(((EntityHitResult)result).m_82443_(), (LivingEntity)shooter, this, 1.0f);
                }
                this.doImpactEffect();
            }
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.ticksInGround > 0) {
            this.m_20334_(0.0, 0.0, 0.0);
            ++this.ticksInGround;
            if (this.ticksInGround >= 80 && !this.f_19853_.f_46443_) {
                this.doImpactEffect();
                return;
            }
            if (!this.f_19853_.f_46443_) {
                this.m_146912_();
            }
        }
    }

    @Override
    public void doImpactEffect() {
        WorldUtil.createExplosion(this.m_37282_(), this.f_19853_, (Entity)this, 2.0f);
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
        }
    }
}

