/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.mob;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;

public abstract class BaseMobProjectile
extends ThrowableProjectile {
    private Type projectileType;
    private AoARangedAttacker shooter;

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, double posX, double posY, double posZ, Type projectileType) {
        super(entityType, world);
        this.m_6034_(posX, posY, posZ);
        this.m_20334_(this.f_19796_.nextGaussian() / 33.0 + 0.03, -2.0, this.f_19796_.nextGaussian() / 33.0 + 0.03);
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, Entity target, Type projectileType) {
        this(entityType, world, shooter, target.m_20185_(), target.m_20186_() + 25.0, target.m_20189_(), projectileType);
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, Type projectileType) {
        super(entityType, world);
        if (shooter instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)shooter;
            this.m_5602_((Entity)owner);
            this.m_6034_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20192_() - (double)0.1f, owner.m_20189_());
        }
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public Type getProjectileType() {
        return this.projectileType;
    }

    public float m_7139_() {
        return 0.0f;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 500) {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult result) {
        if ((result.m_6662_() != HitResult.Type.BLOCK || this.f_19853_.m_8055_(new BlockPos(result.m_82450_())).m_60767_().m_76334_()) && !this.f_19853_.f_46443_) {
            if (result instanceof EntityHitResult) {
                if (((EntityHitResult)result).m_82443_() == this.shooter || this.shooter == null) {
                    return;
                }
                this.shooter.doProjectileEntityImpact(this, ((EntityHitResult)result).m_82443_());
            } else if (result.m_6662_() == HitResult.Type.BLOCK && this.shooter != null) {
                this.shooter.doProjectileBlockImpact(this, this.f_19853_.m_8055_(new BlockPos(result.m_82450_())), new BlockPos(result.m_82450_()), ((BlockHitResult)result).m_82434_());
            }
            this.m_146870_();
        }
    }

    public boolean m_6128_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        MAGIC,
        PHYSICAL,
        GUN,
        OTHER;

    }
}

