/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.LocaleUtil;

public abstract class AdventArmour
extends ArmorItem {
    public AdventArmour(ArmorMaterial material, EquipmentSlot slot) {
        this(material, slot, Rarity.COMMON);
    }

    public AdventArmour(ArmorMaterial material, EquipmentSlot slot, Rarity rarity) {
        this(material, slot, new Item.Properties().m_41491_(AoAItemGroups.ARMOUR).m_41503_(material.m_7366_(slot)).m_41497_(rarity));
    }

    public AdventArmour(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return null;
    }

    public abstract Type setType();

    public void onEquip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
    }

    public void onUnequip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
    }

    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
    }

    public void onDamageDealt(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingHurtEvent event) {
    }

    public void onPreAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingAttackEvent event) {
    }

    public void onAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingHurtEvent event) {
    }

    public void onPostAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingDamageEvent event) {
    }

    public void onPlayerLandingFall(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingFallEvent event) {
    }

    public void onPlayerDeath(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingDeathEvent event) {
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean isSetHelmet(AdventArmour helmet) {
        return this.setType() == helmet.setType() || helmet.setType() == Type.ALL;
    }

    protected TranslatableComponent setEffectHeader() {
        return LocaleUtil.getLocaleMessage("items.description.armour.set", ChatFormatting.GOLD, new Component[0]);
    }

    protected TranslatableComponent pieceEffectHeader() {
        return LocaleUtil.getLocaleMessage("items.description.armour.piece", ChatFormatting.GRAY, new Component[0]);
    }

    protected TranslatableComponent anySetEffectHeader() {
        return LocaleUtil.getLocaleMessage("items.description.armour.anySet", ChatFormatting.DARK_AQUA, new Component[0]);
    }

    public boolean isHelmetAirTight(ServerPlayer player) {
        return false;
    }

    public static enum Type {
        ALACRITY,
        ALL,
        ARCHAIC,
        BARON,
        BATTLEBORN,
        BIOGENIC,
        BOREIC,
        CANDY,
        COMMANDER,
        CRYSTALLIS,
        ELECANYTE,
        EMBRODIUM,
        EXOPLATE,
        EXPLOSIVE,
        FUNGAL,
        GHASTLY,
        GHOULISH,
        HAZMAT,
        HYDRANGIC,
        HYDROPLATE,
        ICE,
        INFERNAL,
        INNERVATION,
        KNIGHT,
        LUNAR,
        LYNDAMYTE,
        LYONIC,
        MERCURIAL,
        NECRO,
        NETHENGEIC,
        NIGHTMARE,
        NONE,
        OMNI,
        PHANTASM,
        POISON,
        PREDATIOUS,
        PRIMORDIAL,
        PURITY,
        ROCKBONE,
        ROSIDIAN,
        RUNIC,
        SHARPSHOT,
        SKELETAL,
        SPACEKING,
        SPEED,
        SUBTERRANEAN,
        UTOPIAN,
        VOID,
        WEAKEN,
        WITHER,
        ZARGONITE;

    }
}

