/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class BattlebornArmour
extends AdventArmour {
    private static final UUID BATTLEBORN_ARMOUR_BUFF = UUID.fromString("5cf50cfa-4298-46d1-b7ec-c648f8e8d5c9");

    public BattlebornArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:battleborn", 65, new int[]{4, 8, 9, 5}, 10, SoundEvents.f_11675_, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.BATTLEBORN;
    }

    private AttributeModifier buff(double currentValue) {
        return new AttributeModifier(BATTLEBORN_ARMOUR_BUFF, "AoABattlebornArmour", currentValue, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public void onDamageDealt(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingHurtEvent event) {
        if (slots != null && DamageUtil.isMeleeDamage(event.getSource())) {
            int counter = plData.equipment().getCooldown("battleborn");
            int newAmount = Math.min(300, counter + slots.size() * 6);
            plData.equipment().setCooldown("battleborn", newAmount);
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22283_, BATTLEBORN_ARMOUR_BUFF);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22283_, this.buff(Math.min(0.65, (double)newAmount / 240.0)), false);
        }
    }

    @Override
    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
        int counter = plData.equipment().getCooldown("battleborn");
        if (counter == 1) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22283_, BATTLEBORN_ARMOUR_BUFF);
        } else if (counter > 0 && plData.player().f_19853_.m_46467_() % 10L == 0L) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22283_, BATTLEBORN_ARMOUR_BUFF);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22283_, this.buff(Math.min(0.65, (double)counter / 240.0)), false);
        }
    }

    @Override
    public void onUnequip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        int cooldown;
        if (slot != null && (cooldown = plData.equipment().getCooldown("battleborn")) > 0) {
            EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22283_, BATTLEBORN_ARMOUR_BUFF);
            plData.equipment().setCooldown("battleborn", (int)((float)cooldown * 0.75f));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.battleborn_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.battleborn_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

