/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class BoreicArmour
extends AdventArmour {
    public BoreicArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:boreic", 62, new int[]{4, 8, 10, 4}, 10, SoundEvents.f_11675_, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.BOREIC;
    }

    @Override
    public void onPostAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingDamageEvent event) {
        ServerPlayer pl = plData.player();
        if (pl.m_20069_() && !DamageUtil.isEnvironmentalDamage(event.getSource())) {
            if (slots != null) {
                WorldUtil.createExplosion((Entity)pl, pl.f_19853_, pl.m_142538_(), 0.7f + 0.3f * (float)slots.size());
            } else {
                for (LivingEntity entity : pl.f_19853_.m_6443_(LivingEntity.class, pl.m_142469_().m_82400_(4.0), EntityUtil.Predicates.HOSTILE_MOB)) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1, false, true));
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.boreic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.boreic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.boreic_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

