/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class CandyArmour
extends AdventArmour {
    public CandyArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:candy", 59, new int[]{4, 7, 9, 4}, 10, SoundEvents.f_11675_, 5.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.CANDY;
    }

    @Override
    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
        if (plData.player().m_36324_().m_38721_() && (slots == null || plData.equipment().isCooledDown("candy_armour")) && this.findAndConsumeFood((Player)plData.player())) {
            plData.equipment().setCooldown("candy_armour", 12000 / (slots == null ? 4 : slots.size()));
        }
    }

    private boolean findAndConsumeFood(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            FoodProperties food;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!stack.m_41720_().m_41472_() || (food = stack.m_41720_().m_41473_()).m_38744_() <= 0 || !(food.m_38745_() > 0.0f)) continue;
            player.m_150109_().m_6836_(i, stack.m_41720_().m_5922_(stack, player.f_19853_, (LivingEntity)player));
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

