/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class KnightArmour
extends AdventArmour {
    public static final AttributeModifier KNIGHT_BOOTS_BUFF = new AttributeModifier(UUID.fromString("9283b669-bc04-4055-a165-73e3a2b5ab7e"), "AoAKnightArmourBoots", 1.5, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier KNIGHT_LEGS_BUFF = new AttributeModifier(UUID.fromString("e60b8cda-a196-4922-b867-01d2422a9e8c"), "AoAKnightArmourLegs", 1.5, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier KNIGHT_CHESTPLATE_BUFF = new AttributeModifier(UUID.fromString("8ecbc122-563a-4de5-8f27-3f461ad2fb5c"), "AoAKnightArmourBody", 1.5, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier KNIGHT_HELMET_BUFF = new AttributeModifier(UUID.fromString("673ef5d8-9df5-4dbb-84f0-1da677d59f05"), "AoAKnightArmourHelmet", 1.5, AttributeModifier.Operation.ADDITION);

    public KnightArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:knight", 70, new int[]{4, 8, 9, 5}, 10, SoundEvents.f_11675_, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.KNIGHT;
    }

    @Override
    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
        if (slots == null && EntityUtil.checkBelowHealthPercentThreshold((LivingEntity)plData.player(), 0.2f)) {
            plData.player().m_7292_(new MobEffectInstance(MobEffects.f_19600_, -1, 1, false, true));
        }
    }

    @Override
    public void onEquip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        if (slot != null) {
            switch (slot) {
                case FEET: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22276_, KNIGHT_BOOTS_BUFF, false);
                    break;
                }
                case LEGS: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22276_, KNIGHT_LEGS_BUFF, false);
                    break;
                }
                case CHEST: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22276_, KNIGHT_CHESTPLATE_BUFF, false);
                    break;
                }
                case HEAD: {
                    EntityUtil.applyAttributeModifierSafely((LivingEntity)plData.player(), Attributes.f_22276_, KNIGHT_HELMET_BUFF, false);
                }
            }
        }
    }

    @Override
    public void onUnequip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        if (slot != null) {
            switch (slot) {
                case FEET: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22276_, KNIGHT_BOOTS_BUFF);
                    break;
                }
                case LEGS: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22276_, KNIGHT_LEGS_BUFF);
                    break;
                }
                case CHEST: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22276_, KNIGHT_CHESTPLATE_BUFF);
                    break;
                }
                case HEAD: {
                    EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), Attributes.f_22276_, KNIGHT_HELMET_BUFF);
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.knight_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.knight_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

