/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class LyonicArmour
extends AdventArmour {
    public LyonicArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:lyonic", 56, new int[]{4, 7, 8, 4}, 10, SoundEvents.f_11675_, 5.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.LYONIC;
    }

    @Override
    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
        block4: {
            if (plData.player().f_19853_.m_46467_() % 2L != 0L) break block4;
            ServerPlayer pl = plData.player();
            if (slots != null) {
                ItemEntity item;
                float range = 1.5f * (float)slots.size();
                Iterator iterator = plData.player().f_19853_.m_45976_(ItemEntity.class, new AABB(pl.m_20185_() - (double)range, pl.m_20186_() - (double)range, pl.m_20189_() - (double)range, pl.m_20185_() + (double)range, pl.m_20186_() + (double)range, pl.m_20189_() + (double)range)).iterator();
                for (pulledCount = 0; iterator.hasNext() && pulledCount <= 200 && this.canPullItem(item = (ItemEntity)iterator.next()); ++pulledCount) {
                    EntityUtil.pullEntityIn((Entity)pl, (Entity)item, 0.05f, true);
                }
            } else {
                Iterator iterator = plData.player().f_19853_.m_45976_(ExperienceOrb.class, new AABB(pl.m_20185_() - 6.0, pl.m_20186_() - 6.0, pl.m_20189_() - 6.0, pl.m_20185_() + 6.0, pl.m_20186_() + 6.0, pl.m_20189_() + 6.0)).iterator();
                while (iterator.hasNext() && pulledCount <= 200) {
                    EntityUtil.pullEntityIn((Entity)pl, (Entity)iterator.next(), 0.05f, true);
                    ++pulledCount;
                }
            }
        }
    }

    @Override
    public void onDamageDealt(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingHurtEvent event) {
    }

    private boolean canPullItem(ItemEntity item) {
        return item.m_6084_() && !item.m_32055_().m_41619_() && !item.m_32063_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.lyonic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.lyonic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.lyonic_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

