/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.blaster.AtomizerBounceEntity;
import net.tslat.aoa3.content.entity.projectile.blaster.AtomizerShotEntity;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class Atomizer
extends BaseBlaster {
    public Atomizer(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_ATOMIZER_FIRE.get();
    }

    @Override
    public void fire(ItemStack blaster, LivingEntity shooter) {
        shooter.f_19853_.m_7967_((Entity)new AtomizerShotEntity(shooter, this, 60));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity shooter) {
        if (shot instanceof AtomizerShotEntity) {
            shot.f_19853_.m_7967_((Entity)new AtomizerBounceEntity(shooter, this, (AtomizerShotEntity)shot, RandomUtil.randomScaledGaussianValue(0.5), 1.3, RandomUtil.randomScaledGaussianValue(0.5)));
        } else {
            WorldUtil.createExplosion((Entity)shooter, shot.f_19853_, (Entity)shot, 1.5f);
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (super.doEntityImpact(shot, target, shooter)) {
            WorldUtil.createExplosion((Entity)shooter, shot.f_19853_, (Entity)shot, 1.5f);
            if (shot instanceof AtomizerShotEntity) {
                shot.f_19853_.m_7967_((Entity)new AtomizerBounceEntity(shooter, this, (AtomizerShotEntity)shot, RandomUtil.randomScaledGaussianValue(0.5), 1.3, RandomUtil.randomScaledGaussianValue(0.5)));
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

