/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.entity.projectile.arrow.PopShotEntity;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class Slingshot
extends BaseBow {
    public static final Predicate<ItemStack> AMMO_PREDICATE = stack -> stack.m_41720_() == AoAItems.POP_SHOT.get() || stack.m_41720_() == Items.f_42484_;
    private final float drawSpeedMultiplier;
    private final double dmg;

    public Slingshot(double damage, float drawSpeedMultiplier, int durability) {
        super(damage, drawSpeedMultiplier, durability);
        this.drawSpeedMultiplier = drawSpeedMultiplier;
        this.dmg = damage;
    }

    @Override
    public void onEntityHit(CustomArrowEntity shot, Entity target, Entity shooter, double damage, float drawStrength) {
        if (shot instanceof PopShotEntity && ((PopShotEntity)shot).isExplosive) {
            WorldUtil.createExplosion(shooter, shot.f_19853_, (Entity)shot, 1.0f);
        }
        shot.m_146870_();
    }

    @Override
    public void onBlockHit(CustomArrowEntity shot, BlockHitResult rayTrace, Entity shooter) {
        if (shot instanceof PopShotEntity && ((PopShotEntity)shot).isExplosive) {
            WorldUtil.createExplosion(shooter, shot.f_19853_, (Entity)shot, 1.0f);
        }
        shot.m_146870_();
    }

    public Predicate<ItemStack> m_6437_() {
        return AMMO_PREDICATE;
    }

    @Override
    public double getArrowDamage(CustomArrowEntity arrow, Entity target, double currentDamage, float drawStrength, boolean isCritical) {
        double damage = currentDamage * (double)(drawStrength / 2.0f);
        if (isCritical) {
            damage += damage + damage * RandomUtil.randomScaledGaussianValue(0.35f);
        }
        return damage;
    }

    @Override
    public CustomArrowEntity doArrowMods(CustomArrowEntity arrow, LivingEntity shooter, ItemStack ammoStack, int useTicksRemaining) {
        PopShotEntity popShot = new PopShotEntity(arrow.f_19853_, this, shooter, this.dmg, ammoStack.m_41720_() instanceof ArrowItem);
        popShot.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, BowItem.m_40661_((int)((int)(72000.0f / this.drawSpeedMultiplier - (float)useTicksRemaining))) * 2.0f, 1.0f);
        return popShot;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.arrows", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{new TextComponent(Double.toString(this.dmg))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.bow.drawSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{new TextComponent(Double.toString((double)(72000.0f / this.drawSpeedMultiplier / 720.0f) / 100.0))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{LocaleUtil.getLocaleMessage(((Item)AoAItems.POP_SHOT.get()).m_5524_()).m_7220_((Component)new TextComponent("/")).m_7220_((Component)LocaleUtil.getLocaleMessage(Items.f_42484_.m_5524_()))}));
    }
}

