/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.greatblade;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoATiers;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.library.constant.AttackSpeed;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class PlutonScythe
extends BaseGreatblade {
    private static final AttributeModifier LUCK_BUFF = new AttributeModifier(UUID.fromString("e446949b-1792-4a66-8f83-5037d6dcce9b"), "AoALuxonScytheLuckBuff", 2.0, AttributeModifier.Operation.ADDITION);

    public PlutonScythe() {
        super((Tier)AoATiers.PLUTON_SCYTHE, AttackSpeed.forAttacksPerSecond(1.0f));
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        AoAResource.Instance spirit;
        float consumeAmount;
        if (!attacker.f_19853_.f_46443_ && (consumeAmount = ((spirit = target instanceof ServerPlayer ? PlayerUtil.getResource((Player)((ServerPlayer)target), (AoAResource)((Object)AoAResources.SPIRIT.get())) : null) != null ? Math.min(50.0f, spirit.getCurrentValue()) : 50.0f) * attackCooldown) > 0.0f) {
            if (spirit != null && !spirit.consume(consumeAmount, true)) {
                return;
            }
            if (attacker instanceof ServerPlayer) {
                PlayerUtil.addResourceToPlayer((ServerPlayer)attacker, (AoAResource)((Object)AoAResources.SPIRIT.get()), consumeAmount);
            }
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22286_, (Object)LUCK_BUFF);
        }
        return multimap;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.scythe", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }
}

