/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.scheduling.async.CoralStaffTask;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class CoralStaff
extends BaseStaff<ArrayList<BlockPos>> {
    public CoralStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CORAL_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.WATER_RUNE.get(), 2);
        runes.put((Item)AoAItems.KINETIC_RUNE.get(), 8);
    }

    @Override
    @Nullable
    public ArrayList<BlockPos> checkPreconditions(LivingEntity caster, ItemStack staff) {
        int y;
        ArrayList<BlockPos> coralPositions = new ArrayList<BlockPos>();
        BlockPos pos = caster.m_142538_();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = -2; x <= 1; ++x) {
            for (int z = -2; z <= 1; ++z) {
                checkPos.m_122178_(pos.m_123341_() + x, pos.m_123342_() - 2, pos.m_123343_() + z);
                if (this.safeBlockPos(caster, (BlockPos)checkPos, staff)) {
                    coralPositions.add(checkPos.m_7949_());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.m_122175_(Direction.UP, 4), staff)) continue;
                coralPositions.add(checkPos.m_7949_());
            }
            for (y = -2; y <= 2; ++y) {
                checkPos.m_122178_(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() - 2);
                if (this.safeBlockPos(caster, (BlockPos)checkPos, staff)) {
                    coralPositions.add(checkPos.m_7949_());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.m_122175_(Direction.SOUTH, 4), staff)) continue;
                coralPositions.add(checkPos.m_7949_());
            }
        }
        for (int z = -2; z <= 2; ++z) {
            for (y = -2; y <= 2; ++y) {
                checkPos.m_122178_(pos.m_123341_() - 2, pos.m_123342_() + y, pos.m_123343_() + z);
                if (this.safeBlockPos(caster, (BlockPos)checkPos, staff)) {
                    coralPositions.add(checkPos.m_7949_());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.m_122175_(Direction.EAST, 4), staff)) continue;
                coralPositions.add(checkPos.m_7949_());
            }
        }
        return coralPositions.isEmpty() ? null : coralPositions;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, ArrayList<BlockPos> args) {
        if (!world.f_46443_ && caster instanceof Player) {
            for (BlockPos pos : args) {
                world.m_7731_(pos, Blocks.f_50585_.m_49966_(), 2);
            }
            world.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)AoASounds.ITEM_REEF_STAFF_CAST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            new CoralStaffTask(world, args).schedule(30, TimeUnit.SECONDS);
        }
    }

    private boolean safeBlockPos(LivingEntity caster, BlockPos pos, ItemStack staff) {
        return caster.f_19853_.m_8055_(pos).m_60734_() == Blocks.f_50016_ && WorldUtil.canPlaceBlock((LevelAccessor)caster.f_19853_, pos, (Entity)caster, staff);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

