/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class CrystonStaff
extends BaseStaff<Integer> {
    public CrystonStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CRYSTEVIA_STAFF_CAST.get();
    }

    @Override
    public Integer checkPreconditions(LivingEntity caster, ItemStack staff) {
        int count = caster.f_19853_.m_6443_(LivingEntity.class, caster.m_142469_().m_82400_(10.0), EntityUtil.Predicates.HOSTILE_MOB).size();
        if (count > 0) {
            return count;
        }
        return null;
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.DISTORTION_RUNE.get(), 2);
        runes.put((Item)AoAItems.ENERGY_RUNE.get(), 4);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, Integer args) {
        EntityUtil.applyPotions((Entity)caster, new EffectBuilder(MobEffects.f_19596_, Math.min(args * 100, 1200)).level(Math.min(args, 3)));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

