/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class EmberStaff
extends BaseStaff<Object> {
    public EmberStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_EMBER_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.KINETIC_RUNE.get(), 1);
        runes.put((Item)AoAItems.WIND_RUNE.get(), 1);
        runes.put((Item)AoAItems.FIRE_RUNE.get(), 1);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, Object args) {
        caster.m_20095_();
        for (LivingEntity entity2 : world.m_6443_(LivingEntity.class, caster.m_142469_().m_82400_(5.0), entity -> entity instanceof Player || entity instanceof TamableAnimal)) {
            entity2.m_20095_();
        }
        WorldUtil.operateOnMultipleBlocksInRange(world, caster.m_142538_(), 5, state -> state.m_60734_() == Blocks.f_50083_, pos -> world.m_46597_(pos, Blocks.f_50016_.m_49966_()));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

