/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class ShowStaff
extends BaseStaff<List<LivingEntity>> {
    public ShowStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_SHOW_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.COMPASS_RUNE.get(), 3);
        runes.put((Item)AoAItems.POWER_RUNE.get(), 3);
    }

    @Override
    public List<LivingEntity> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List list = caster.f_19853_.m_6443_(LivingEntity.class, caster.m_142469_().m_82400_(30.0), EntityUtil.Predicates.HOSTILE_MOB);
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        for (LivingEntity entity : args) {
            entity.m_20254_(5);
            EntityUtil.applyPotions((Entity)entity, new EffectBuilder(MobEffects.f_19619_, 100));
            world.m_7967_((Entity)new FireworkRocketEntity(world, entity.m_20185_(), entity.m_142469_().f_82292_, entity.m_20189_(), this.makeFireworksStack()));
        }
    }

    private ItemStack makeFireworksStack() {
        ItemStack fireworks = new ItemStack((ItemLike)Items.f_42688_, 1);
        CompoundTag explosionTag = new CompoundTag();
        CompoundTag fireworksTag = new CompoundTag();
        CompoundTag finalTag = new CompoundTag();
        CompoundTag wrapperTag = new CompoundTag();
        ListTag finalTagList = new ListTag();
        explosionTag.m_128379_("Trail", true);
        explosionTag.m_128385_("Colors", new int[]{0});
        explosionTag.m_128344_("Type", (byte)4);
        fireworksTag.m_128365_("Explosion", (Tag)explosionTag);
        finalTagList.add((Object)fireworksTag);
        finalTag.m_128365_("Explosions", (Tag)finalTagList);
        finalTag.m_128344_("Flight", (byte)3);
        wrapperTag.m_128365_("Fireworks", (Tag)finalTag);
        fireworks.m_41751_(wrapperTag);
        return fireworks;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

