/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityProvider;

public class BaseSword
extends SwordItem {
    private final Lazy<ImmutableSetMultimap<Attribute, AttributeModifier>> attributeModifiers;
    protected final float dmg;
    protected final double speed;

    public BaseSword(Tier tier) {
        this(tier, 0, -2.4f);
    }

    public BaseSword(Tier itemStats, Item.Properties properties) {
        this(itemStats, 0, -2.4f, properties);
    }

    public BaseSword(Tier tier, int damageMod, float attackSpeed) {
        this(tier, damageMod, attackSpeed, new Item.Properties().m_41503_(tier.m_6609_()).m_41491_(AoAItemGroups.SWORDS));
    }

    public BaseSword(Tier tier, int damageMod, float attackSpeed, Item.Properties properties) {
        super(tier, damageMod, attackSpeed, properties);
        this.dmg = (float)damageMod + tier.m_6631_();
        this.speed = attackSpeed;
        this.attributeModifiers = this.buildDefaultAttributes();
    }

    public float m_43299_() {
        return this.dmg;
    }

    public double getAttackSpeed() {
        return this.speed;
    }

    protected Lazy<ImmutableSetMultimap<Attribute, AttributeModifier>> buildDefaultAttributes() {
        return Lazy.of(() -> ImmutableSetMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.getAttackSpeed(), AttributeModifier.Operation.ADDITION)));
    }

    public double getDamageForAttack(LivingEntity target, LivingEntity attacker, ItemStack swordStack, double baseDamage) {
        return baseDamage;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        VolatileStackCapabilityProvider.getOrDefault(stack, Direction.NORTH).setValue(player.m_36403_(0.0f));
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.doMeleeEffect(stack, target, attacker, VolatileStackCapabilityProvider.getOrDefault(stack, Direction.NORTH).getValue());
        return super.m_7579_(stack, target, attacker);
    }

    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new VolatileStackCapabilityProvider();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            HashMultimap newMap = HashMultimap.create();
            ImmutableSetMultimap attributes = (ImmutableSetMultimap)this.attributeModifiers.get();
            for (Map.Entry entry : attributes.entries()) {
                newMap.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
            }
            return newMap;
        }
        return super.m_7167_(slot);
    }
}

