/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.AoALootOperations;

public class BlockHasTag
implements LootItemCondition {
    private final TagKey<Block>[] tags;
    private final boolean requireAll;

    public BlockHasTag(TagKey<Block> ... tags) {
        this(false, tags);
    }

    public BlockHasTag(boolean requireAll, TagKey<Block> ... tags) {
        this.tags = tags;
        this.requireAll = requireAll;
    }

    public boolean test(LootContext lootContext) {
        BlockState state = (BlockState)lootContext.m_78953_(LootContextParams.f_81461_);
        if (state != null) {
            if (this.requireAll) {
                for (TagKey<Block> tag : this.tags) {
                    if (state.m_204336_(tag)) continue;
                    return false;
                }
                return true;
            }
            for (TagKey<Block> tag : this.tags) {
                if (!state.m_204336_(tag)) continue;
                return true;
            }
        }
        return false;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)AoALootOperations.LootConditions.HAS_BLOCK_TAG.get();
    }

    public TagKey<Block>[] getTags() {
        return this.tags;
    }

    public boolean requiresAllTags() {
        return this.requireAll;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<BlockHasTag> {
        public void serialize(JsonObject json, BlockHasTag instance, JsonSerializationContext jsonSerializationContext) {
            JsonArray tagsArray = new JsonArray();
            for (TagKey<Block> tag : instance.tags) {
                tagsArray.add(tag.f_203868_().toString());
            }
            json.addProperty("require_all", Boolean.valueOf(instance.requireAll));
            json.add("tags", (JsonElement)tagsArray);
        }

        public BlockHasTag deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext) {
            JsonArray tagsArray = GsonHelper.m_13933_((JsonObject)json, (String)"tags");
            TagKey[] tags = new TagKey[tagsArray.size()];
            for (int i = 0; i < tagsArray.size(); ++i) {
                tags[i] = BlockTags.create((ResourceLocation)new ResourceLocation(tagsArray.get(i).getAsString()));
            }
            return new BlockHasTag(GsonHelper.m_13855_((JsonObject)json, (String)"require_all", (boolean)false), tags);
        }
    }
}

