/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.AoALootOperations;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.PlayerUtil;

public class PlayerHasResource
implements LootItemCondition {
    private final AoAResource resource;
    private final float amount;
    private final boolean consume;

    public PlayerHasResource(AoAResource resource, float amount, boolean consume) {
        this.resource = resource;
        this.amount = amount;
        this.consume = consume;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)AoALootOperations.LootConditions.PLAYER_HAS_RESOURCE.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81458_);
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_78953_(LootContextParams.f_81458_);
        if (entity == null) {
            entity = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        }
        if (entity instanceof ServerPlayer) {
            return this.consume ? PlayerUtil.consumeResource((ServerPlayer)entity, this.resource, this.amount, false) : PlayerUtil.getResourceValue((Player)((ServerPlayer)entity), this.resource) >= this.amount;
        }
        return false;
    }

    public AoAResource getResource() {
        return this.resource;
    }

    public float getAmount() {
        return this.amount;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<PlayerHasResource> {
        public void serialize(JsonObject json, PlayerHasResource playerHasResource, JsonSerializationContext jsonSerializationContext) {
            json.addProperty("resource", playerHasResource.resource.getRegistryName().toString());
            json.addProperty("amount", (Number)Float.valueOf(playerHasResource.amount));
            json.addProperty("consume", Boolean.valueOf(playerHasResource.consume));
        }

        public PlayerHasResource deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext) {
            return new PlayerHasResource(AoAResources.getResource(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"resource"))), GsonHelper.m_13915_((JsonObject)json, (String)"amount"), GsonHelper.m_13900_((JsonObject)json, (String)"consume") && GsonHelper.m_13912_((JsonObject)json, (String)"consume"));
        }
    }
}

