/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.misc.FertilisedFarmland;
import net.tslat.aoa3.util.ItemUtil;

public class FertilisedFarmlandLootModifier
extends LootModifier {
    public FertilisedFarmlandLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (generatedLoot.isEmpty()) {
            return generatedLoot;
        }
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        Vec3 pos = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (state != null && pos != null && state.m_60734_() instanceof CropBlock && state.m_60734_() != AoABlocks.GREEN_MANURE.get()) {
            BlockPos farmlandPos = new BlockPos(pos).m_7495_();
            BlockState belowBlock = context.m_78952_().m_8055_(farmlandPos);
            if (belowBlock.m_60734_() instanceof FertilisedFarmland && belowBlock.m_60734_().canSustainPlant(belowBlock, (BlockGetter)context.m_78952_(), farmlandPos, Direction.UP, (IPlantable)state.m_60734_())) {
                int increaseAmount = (Boolean)belowBlock.m_61143_((Property)FertilisedFarmland.WELL_FERTILISED) != false ? 2 : 1;
                Item seeds = ((CropBlock)state.m_60734_()).m_7397_((BlockGetter)context.m_78952_(), new BlockPos(pos), state).m_41720_();
                ListIterator<ItemStack> iterator = generatedLoot.listIterator();
                while (iterator.hasNext()) {
                    ItemStack itStack = iterator.next();
                    if (itStack.m_41720_() == seeds) continue;
                    ItemUtil.increaseStackSize(itStack, increaseAmount).forEach(iterator::add);
                }
                context.m_78952_().m_7731_(farmlandPos, (BlockState)(increaseAmount == 2 ? ((Block)AoABlocks.FERTILISED_FARMLAND.get()).m_49966_() : Blocks.f_50093_.m_49966_()).m_61124_((Property)FarmBlock.f_53243_, (Comparable)((Integer)belowBlock.m_61143_((Property)FarmBlock.f_53243_))), 3);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<FertilisedFarmlandLootModifier> {
        public FertilisedFarmlandLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] lootConditions) {
            return new FertilisedFarmlandLootModifier(lootConditions);
        }

        public JsonObject write(FertilisedFarmlandLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("type", this.getRegistryName().toString());
            return json;
        }
    }
}

