/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tslat.aoa3.common.container.DivineStationContainer;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;

public class UpgradeKitRecipe
implements Recipe<DivineStationContainer.DivineStationInventory> {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack input;
    private final ItemStack upgradeKit;
    private final ItemStack output;

    public UpgradeKitRecipe(ResourceLocation id, String group, ItemStack input, ItemStack upgradeKit, ItemStack output) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.upgradeKit = upgradeKit;
        this.output = output;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)AoABlocks.DIVINE_STATION.get());
    }

    public boolean matches(DivineStationContainer.DivineStationInventory inv, Level world) {
        return ItemStack.m_41746_((ItemStack)this.input, (ItemStack)inv.m_8020_(0)) && ItemStack.m_41746_((ItemStack)this.upgradeKit, (ItemStack)inv.m_8020_(1));
    }

    public ItemStack assemble(DivineStationContainer.DivineStationInventory inv) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= 3;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<UpgradeKitRecipe> m_7707_() {
        return (RecipeSerializer)AoARecipes.UPGRADE_KIT.serializer().get();
    }

    public RecipeType<UpgradeKitRecipe> m_6671_() {
        return (RecipeType)AoARecipes.UPGRADE_KIT.type().get();
    }

    public NonNullList<ItemStack> getRemainingItems(DivineStationContainer.DivineStationInventory inv) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return remainingItems;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.input}));
        ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.upgradeKit}));
        return ingredients;
    }

    public String m_6076_() {
        return this.group;
    }

    public static class Factory
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<UpgradeKitRecipe> {
        public UpgradeKitRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ItemStack inputItem = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"input"), (boolean)false);
            ItemStack upgradeKit = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"upgrade_kit"), (boolean)false);
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new UpgradeKitRecipe(recipeId, group, inputItem, upgradeKit, output);
        }

        @Nullable
        public UpgradeKitRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            ItemStack inputItem = buffer.m_130267_();
            ItemStack upgradeKit = buffer.m_130267_();
            ItemStack output = buffer.m_130267_();
            return new UpgradeKitRecipe(recipeId, group, inputItem, upgradeKit, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, UpgradeKitRecipe recipe) {
            buffer.m_130072_(recipe.m_6076_(), Short.MAX_VALUE);
            buffer.m_130055_(recipe.input);
            buffer.m_130055_(recipe.upgradeKit);
            buffer.m_130055_(recipe.output);
        }
    }
}

