/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.content.world.gen.structure.JigsawAssembler;
import org.apache.commons.lang3.mutable.MutableObject;

public class GenericAoAStructure<T extends JigsawConfiguration>
extends StructureFeature<T> {
    private final GenerationStep.Decoration genStage;

    public GenericAoAStructure(Codec<T> codec) {
        this(codec, new PieceGen());
    }

    public GenericAoAStructure(Codec<T> codec, PieceGeneratorSupplier<T> pieceGen) {
        this(codec, pieceGen, GenerationStep.Decoration.SURFACE_STRUCTURES);
    }

    public GenericAoAStructure(Codec<T> codec, PieceGeneratorSupplier<T> pieceGen, GenerationStep.Decoration genStage) {
        super(codec, pieceGen, PostPlacementProcessor.f_192427_);
        this.genStage = genStage;
    }

    public GenerationStep.Decoration m_67095_() {
        return this.genStage;
    }

    public static class PieceGen<C extends JigsawConfiguration>
    implements PieceGeneratorSupplier<C> {
        protected int maxPiecesDepth(PieceGeneratorSupplier.Context<C> genContext) {
            return 10;
        }

        protected boolean lockRotation(PieceGeneratorSupplier.Context<C> genContext) {
            return false;
        }

        protected boolean genOnWorldSurface(PieceGeneratorSupplier.Context<C> genContext) {
            return true;
        }

        protected boolean shouldGenInChunk(PieceGeneratorSupplier.Context<C> genContext) {
            return true;
        }

        protected boolean checkAndAdjustGeneration(PieceGeneratorSupplier.Context<C> genContext, WorldgenRandom rand, BlockPos.MutableBlockPos currentPos) {
            int y = genContext.f_197352_().m_156179_(currentPos.m_123341_(), currentPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, genContext.f_197357_());
            if (this.genOnWorldSurface(genContext)) {
                currentPos.m_142448_(y);
            }
            return y >= genContext.f_197357_().m_141937_();
        }

        protected StructurePoolElement getStartPoolElement(PieceGeneratorSupplier.Context<C> genContext, WorldgenRandom rand, BlockPos.MutableBlockPos pos) {
            return ((StructureTemplatePool)((JigsawConfiguration)genContext.f_197356_()).m_204802_().m_203334_()).m_210585_((Random)rand);
        }

        public Optional<PieceGenerator<C>> m_197347_(PieceGeneratorSupplier.Context<C> genContext) {
            if (!this.shouldGenInChunk(genContext)) {
                return Optional.empty();
            }
            BlockPos.MutableBlockPos chunkCenter = genContext.f_197355_().m_151394_(0).m_122032_();
            WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            rand.m_190068_(genContext.f_197354_(), genContext.f_197355_().f_45578_, genContext.f_197355_().f_45579_);
            if (!this.checkAndAdjustGeneration(genContext, rand, chunkCenter)) {
                return Optional.empty();
            }
            StructureFeature.m_67096_();
            ChunkGenerator chunkGenerator = genContext.f_197352_();
            StructureManager structureManager = genContext.f_197359_();
            Predicate predicate = genContext.f_197358_();
            Rotation rotation = this.lockRotation(genContext) ? Rotation.NONE : Rotation.m_55956_((Random)rand);
            StructurePoolElement startElement = this.getStartPoolElement(genContext, rand, chunkCenter);
            if (startElement == EmptyPoolElement.f_210175_) {
                return Optional.empty();
            }
            JigsawPlacement.PieceFactory pieceFactory = PoolElementStructurePiece::new;
            PoolElementStructurePiece startPiece = pieceFactory.m_210300_(structureManager, startElement, (BlockPos)chunkCenter, startElement.m_210540_(), rotation, startElement.m_207470_(structureManager, (BlockPos)chunkCenter, rotation));
            BoundingBox startBounds = startPiece.m_73547_();
            int centerX = (startBounds.m_162399_() + startBounds.m_162395_()) / 2;
            int centerZ = (startBounds.m_162401_() + startBounds.m_162398_()) / 2;
            if (!predicate.test(chunkGenerator.m_203495_(QuartPos.m_175400_((int)centerX), QuartPos.m_175400_((int)chunkCenter.m_123342_()), QuartPos.m_175400_((int)centerZ)))) {
                return Optional.empty();
            }
            int yAdjust = startBounds.m_162396_() + startPiece.m_72647_();
            startPiece.m_6324_(0, chunkCenter.m_123342_() - yAdjust, 0);
            return this.createNewPieceGenerator(startPiece, centerX, centerZ, genContext, rand, pieceFactory, startBounds);
        }

        protected Optional<PieceGenerator<C>> createNewPieceGenerator(PoolElementStructurePiece startPiece, int centerX, int centerZ, PieceGeneratorSupplier.Context<C> genContext, WorldgenRandom rand, JigsawPlacement.PieceFactory pieceFactory, BoundingBox startBounds) {
            return Optional.of((pieceBuilder, context2) -> {
                ArrayList pieces = Lists.newArrayList();
                LevelHeightAccessor level = genContext.f_197357_();
                pieces.add(startPiece);
                if (this.maxPiecesDepth(genContext) > 0) {
                    AABB safeBounds = new AABB((double)(centerX - 80), (double)level.m_141937_(), (double)(centerZ - 80), (double)(centerX + 80 + 1), (double)level.m_151558_(), (double)(centerZ + 80 + 1));
                    JigsawAssembler assembler = new JigsawAssembler((Registry<StructureTemplatePool>)genContext.f_197360_().m_175515_(Registry.f_122884_), this.maxPiecesDepth(genContext), pieceFactory, genContext.f_197352_(), genContext.f_197359_(), pieces, (Random)rand);
                    assembler.placementQueue.addLast(new JigsawAssembler.Entry(startPiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)safeBounds), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)startBounds)), (BooleanOp)BooleanOp.f_82685_)), 0));
                    while (!assembler.placementQueue.isEmpty()) {
                        JigsawAssembler.Entry entry = assembler.placementQueue.removeFirst();
                        assembler.tryPlacingChildren(entry.piece, entry.free, entry.depth, false, level);
                    }
                    pieces.forEach(arg_0 -> ((StructurePiecesBuilder)pieceBuilder).m_142679_(arg_0));
                }
            });
        }
    }
}

