/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class BloodtwisterTreeFeature
extends AoATreeFeature {
    public BloodtwisterTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int weaveHeight;
        int trunkHeight = 5 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + (weaveHeight = 8 + rand.nextInt(8)), 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.BLOOD_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.BLOOD_LEAVES.get()).m_49966_();
        BlockState barkLog = ((Block)AoABlocks.BLOOD_WOOD.get()).m_49966_();
        this.placeBlock(reader, pos.m_6630_(1 + rand.nextInt(3)), ((Block)AoABlocks.EYEBALL_LOG.get()).m_49966_());
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        this.placeBlock(reader, movablePos.m_142082_(1, 0, 0), barkLog);
        this.placeBlock(reader, movablePos.m_142082_(0, 0, 1), barkLog);
        this.placeBlock(reader, (BlockPos)movablePos, barkLog);
        this.placeBlock(reader, movablePos.m_142082_(-1, 0, 0), barkLog);
        this.placeBlock(reader, movablePos.m_142082_(0, 0, -1), barkLog);
        this.placeBlock(reader, movablePos.m_142082_(2, 0, 0), leaves);
        this.placeBlock(reader, movablePos.m_142082_(0, 0, 2), leaves);
        this.placeBlock(reader, movablePos.m_142082_(-2, 0, 0), leaves);
        this.placeBlock(reader, movablePos.m_142082_(0, 0, -2), leaves);
        this.placeBlock(reader, movablePos.m_142082_(3, 0, 0), leaves);
        this.placeBlock(reader, movablePos.m_142082_(0, 0, 3), leaves);
        this.placeBlock(reader, movablePos.m_142082_(-3, 0, 0), leaves);
        this.placeBlock(reader, movablePos.m_142082_(0, 0, -3), leaves);
        if (rand.nextBoolean()) {
            Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            int turnMod = rand.nextBoolean() ? 3 : 4;
            int direction = 0;
            int curBaseDirection = 0;
            BlockPos basePos = movablePos.m_7949_();
            movablePos.m_122175_(Direction.WEST, 3);
            for (int i = 1; i <= weaveHeight; ++i) {
                this.placeBlock(reader, (BlockPos)movablePos.m_122173_(directions[direction]), leaves);
                this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), leaves);
                if (i == weaveHeight && curBaseDirection < 3) {
                    movablePos.m_122190_((Vec3i)basePos).m_122175_(directions[curBaseDirection], 3);
                    direction = ++curBaseDirection;
                    i = 1;
                }
                if (i % turnMod != 0 || ++direction <= 3) continue;
                direction = 0;
            }
        } else {
            Direction[] directions = new Direction[]{Direction.SOUTH, Direction.EAST, Direction.NORTH, Direction.WEST};
            int turnMod = rand.nextBoolean() ? 3 : 4;
            int direction = 0;
            int curBaseDirection = 0;
            BlockPos basePos = movablePos.m_7949_();
            movablePos.m_122175_(Direction.WEST, 3);
            for (int i = 1; i <= weaveHeight; ++i) {
                this.placeBlock(reader, (BlockPos)movablePos.m_122173_(directions[direction]), leaves);
                this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), leaves);
                if (i == weaveHeight && curBaseDirection < 3) {
                    movablePos.m_122190_((Vec3i)basePos).m_122175_(directions[curBaseDirection], 3);
                    direction = ++curBaseDirection;
                    i = 1;
                }
                if (i % turnMod != 0 || ++direction <= 3) continue;
                direction = 0;
            }
        }
        return true;
    }
}

