/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoAVariableLeafTreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public abstract class CelevusTreeFeature
extends AoAVariableLeafTreeFeature {
    public CelevusTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        BlockPos multiSaplingPos = this.findMultiSaplingPosition(reader, rand, pos, 2, isWorldGen);
        boolean success = multiSaplingPos == null || isWorldGen && rand.nextInt(6) != 0 ? this.genSmallTree(reader, rand, pos, leafBlock, isWorldGen) : this.genBigTree(reader, rand, multiSaplingPos, leafBlock, isWorldGen);
        return success;
    }

    public boolean genBigTree(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int x;
        int z;
        int trunkHeight = 15 + rand.nextInt(10);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 5, 2, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 2, isWorldGen)) {
            return false;
        }
        BlockState baseSoil = reader.m_8055_(pos.m_7495_());
        for (int x2 = 0; x2 < 2; ++x2) {
            for (int z2 = 0; z2 < 2; ++z2) {
                BlockPos testPos = pos.m_142082_(x2, -1, z2);
                if (!reader.m_8055_(testPos).m_60713_(Blocks.f_50016_)) continue;
                reader.m_7731_(testPos, baseSoil, 2);
            }
        }
        BlockState log = ((Block)AoABlocks.CELEVE_STEM.get()).m_49966_();
        boolean clockwise = rand.nextBoolean();
        boolean thickTwist = rand.nextBoolean();
        int twistOffset = 1 + rand.nextInt(3);
        block8: for (int i = 0; i < trunkHeight; ++i) {
            for (int x3 = 0; x3 <= 1; ++x3) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x3, i, z), log);
                }
            }
            switch ((i + twistOffset) % 4) {
                case 0: {
                    this.placeBlock(reader, pos.m_142082_(0, i, 0), leafBlock, true);
                    if (!thickTwist) continue block8;
                    this.placeBlock(reader, pos.m_142082_(0, i - 1, 0), leafBlock, true);
                    continue block8;
                }
                case 1: {
                    if (clockwise) {
                        this.placeBlock(reader, pos.m_142082_(0, i, 1), leafBlock, true);
                        if (!thickTwist || i <= 0) continue block8;
                        this.placeBlock(reader, pos.m_142082_(0, i - 1, 1), leafBlock, true);
                        continue block8;
                    }
                    this.placeBlock(reader, pos.m_142082_(1, i, 0), leafBlock, true);
                    if (!thickTwist || i <= 0) continue block8;
                    this.placeBlock(reader, pos.m_142082_(1, i - 1, 0), leafBlock, true);
                    continue block8;
                }
                case 2: {
                    this.placeBlock(reader, pos.m_142082_(1, i, 1), leafBlock, true);
                    if (!thickTwist || i <= 0) continue block8;
                    this.placeBlock(reader, pos.m_142082_(1, i - 1, 1), leafBlock, true);
                    continue block8;
                }
                case 3: {
                    if (clockwise) {
                        this.placeBlock(reader, pos.m_142082_(1, i, 0), leafBlock, true);
                        if (!thickTwist || i <= 0) continue block8;
                        this.placeBlock(reader, pos.m_142082_(1, i - 1, 0), leafBlock, true);
                        continue block8;
                    }
                    this.placeBlock(reader, pos.m_142082_(0, i, 1), leafBlock, true);
                    if (!thickTwist || i <= 0) continue block8;
                    this.placeBlock(reader, pos.m_142082_(0, i - 1, 1), leafBlock, true);
                }
            }
        }
        pos = pos.m_6630_(trunkHeight);
        for (x = -1; x <= 2; ++x) {
            for (int z3 = -1; z3 <= 2; ++z3) {
                this.placeBlock(reader, pos.m_142082_(x, 0, z3), leafBlock);
                this.placeBlock(reader, pos.m_142082_(x, 5, z3), leafBlock);
            }
        }
        for (x = -2; x <= 3; ++x) {
            for (int y = 1; y <= 4; ++y) {
                for (z = -2; z <= 3; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x, y, z), leafBlock);
                }
            }
        }
        return true;
    }

    public boolean genSmallTree(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int z;
        int x;
        int trunkHeight = 8 + rand.nextInt(7);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 5, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.CELEVE_STEM.get()).m_49966_();
        BlockState whiteLeaves = ((Block)AoABlocks.WHITE_CELEVUS_LEAVES.get()).m_49966_();
        int leafRingGap = -1;
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
            if (leafRingGap > 1 && i < trunkHeight - 1 && rand.nextBoolean()) {
                leafRingGap = 0;
                for (int x2 = -1; x2 <= 1; ++x2) {
                    for (int z2 = -1; z2 <= 1; ++z2) {
                        this.placeBlock(reader, movablePos.m_142082_(x2, 0, z2), leafBlock);
                    }
                }
            }
            ++leafRingGap;
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                this.placeBlock(reader, movablePos.m_142082_(x, 0, z), whiteLeaves);
                this.placeBlock(reader, movablePos.m_142082_(x, 5, z), leafBlock);
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                this.placeBlock(reader, movablePos.m_142082_(x, 1, z), leafBlock);
                this.placeBlock(reader, movablePos.m_142082_(x, 2, z), whiteLeaves);
                this.placeBlock(reader, movablePos.m_142082_(x, 3, z), leafBlock);
                this.placeBlock(reader, movablePos.m_142082_(x, 4, z), whiteLeaves);
            }
        }
        return true;
    }
}

