/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.block.generation.plants.VinesBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class CreepTreeFeature
extends AoATreeFeature {
    private static final BlockState leaves = ((Block)AoABlocks.CREEP_LEAVES.get()).m_49966_();
    private static final BlockState vines = ((Block)AoABlocks.CREEP_VINES.get()).m_49966_();

    public CreepTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        ArrayList<BlockPos> leafPositions = new ArrayList<BlockPos>();
        int trunkHeight = 6 + rand.nextInt(10);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.CREEP_LOG.get()).m_49966_();
        int ringLocation = 1 + rand.nextInt(trunkHeight - 3);
        if (ringLocation < trunkHeight / 2) {
            ringLocation = -1;
        }
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
            if (i != ringLocation) continue;
            int ringWidth = 1 + rand.nextInt(2);
            for (int y = 0; y <= rand.nextInt(2); ++y) {
                for (int x = -ringWidth; x <= ringWidth; ++x) {
                    for (int z = -ringWidth; z <= ringWidth; ++z) {
                        this.placeLeafBlock(reader, movablePos.m_142082_(x, y, z), leafPositions);
                    }
                }
            }
        }
        if (rand.nextBoolean()) {
            int width = 1 + rand.nextInt(2);
            for (int y = 0; y <= 1 + rand.nextInt(2); ++y) {
                for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        this.placeLeafBlock(reader, movablePos.m_142082_(x, y, z), leafPositions);
                    }
                }
            }
        } else {
            for (int y = 0; y > -rand.nextInt(3); --y) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        this.placeLeafBlock(reader, movablePos.m_142082_(x, y, z), leafPositions);
                    }
                }
            }
            if (rand.nextBoolean()) {
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (x * x + z * z > 4) continue;
                        this.placeLeafBlock(reader, movablePos.m_142082_(x, 1, z), leafPositions);
                    }
                }
            } else {
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        this.placeLeafBlock(reader, movablePos.m_142082_(x, 1, z), leafPositions);
                    }
                }
            }
        }
        this.populateVines(reader, rand, leafPositions);
        return true;
    }

    private void placeLeafBlock(WorldGenLevel reader, BlockPos leafPos, ArrayList<BlockPos> leafPositions) {
        this.placeBlock(reader, leafPos, leaves);
        leafPositions.add(leafPos);
    }

    private void populateVines(WorldGenLevel reader, Random rand, ArrayList<BlockPos> leafPositions) {
        for (BlockPos pos : leafPositions) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos vinePos;
                if (!(rand.nextFloat() < 0.65f) || !reader.m_46859_(vinePos = pos.m_142300_(dir))) continue;
                BlockState state = ((VinesBlock)vines.m_60734_()).getStateForPosition((LevelAccessor)reader, vinePos);
                this.placeBlock(reader, vinePos, state);
                for (int count = 0; count < 2 && rand.nextFloat() < 0.65f && reader.m_46859_(vinePos = vinePos.m_7495_()); ++count) {
                    state = ((VinesBlock)vines.m_60734_()).getStateForPosition((LevelAccessor)reader, vinePos);
                    this.placeBlock(reader, vinePos, state);
                }
            }
        }
    }
}

