/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class EyebushTreeFeature
extends AoATreeFeature {
    public EyebushTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        boolean doubleTrunk = rand.nextBoolean();
        if (!this.checkSafeHeight(reader, pos, (doubleTrunk ? 2 : 1) + 5, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockState log = ((Block)AoABlocks.EYEBALL_LOG.get()).m_49966_();
        this.placeBlock(reader, pos, log);
        pos = pos.m_7494_();
        if (doubleTrunk) {
            this.placeBlock(reader, pos, log);
            pos = pos.m_7494_();
        }
        this.placeBlock(reader, pos.m_142127_(), log);
        this.placeBlock(reader, pos.m_142128_(), log);
        this.placeBlock(reader, pos.m_142126_(), log);
        this.placeBlock(reader, pos.m_142125_(), log);
        this.placeBlock(reader, pos.m_7494_(), log);
        this.placeBlock(reader, pos.m_6630_(2), log);
        this.buildLeafRing(reader, pos, 2);
        this.buildLeafRing(reader, pos.m_7494_(), 3);
        this.buildLeafRing(reader, pos.m_6630_(2), 2);
        this.buildLeafRing(reader, pos.m_6630_(3), 1);
        this.placeBlock(reader, pos.m_6630_(4), ((Block)AoABlocks.VEIN_LEAVES.get()).m_49966_());
        return true;
    }

    private void buildLeafRing(WorldGenLevel reader, BlockPos pos, int radius) {
        BlockState leaves = ((Block)AoABlocks.VEIN_LEAVES.get()).m_49966_();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if ((x == radius || x == -radius) && (z == radius || z == -radius)) continue;
                this.placeBlock(reader, pos.m_142082_(x, 0, z), leaves);
            }
        }
    }
}

