/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoAVariableLeafTreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public abstract class HavenTreeFeature
extends AoAVariableLeafTreeFeature {
    public HavenTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        BlockPos multiSaplingPos = this.findMultiSaplingPosition(reader, rand, pos, 2, isWorldGen);
        return switch (rand.nextInt(3) + (multiSaplingPos == null ? 0 : 3)) {
            case 0 -> this.generateTree1(reader, rand, pos, leafBlock, isWorldGen);
            case 1 -> this.generateTree2(reader, rand, pos, leafBlock, isWorldGen);
            case 2 -> this.generateTree3(reader, rand, pos, leafBlock, isWorldGen);
            case 3 -> this.generateTree4(reader, rand, multiSaplingPos, leafBlock, isWorldGen);
            case 4 -> this.generateTree5(reader, rand, multiSaplingPos, leafBlock, isWorldGen);
            case 5 -> this.generateTree6(reader, rand, multiSaplingPos, leafBlock, isWorldGen);
            default -> false;
        };
    }

    private boolean generateTree1(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int trunkHeight = 10 + rand.nextInt(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = Blocks.f_49999_.m_49966_();
        boolean builtLeafRing = false;
        for (int i = 0; i < trunkHeight; ++i) {
            int z;
            int x;
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
            if (builtLeafRing || i <= 1 || i < trunkHeight - 4 && rand.nextInt(3) != 0) continue;
            BlockPos leafPosBase = movablePos.m_7949_();
            this.placeBlock(reader, leafPosBase.m_142300_(Direction.NORTH), leafBlock);
            this.placeBlock(reader, leafPosBase.m_142300_(Direction.EAST), leafBlock);
            this.placeBlock(reader, leafPosBase.m_142300_(Direction.SOUTH), leafBlock);
            this.placeBlock(reader, leafPosBase.m_142300_(Direction.WEST), leafBlock);
            leafPosBase = leafPosBase.m_7494_();
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    if (Math.abs(x * z) >= 2) continue;
                    this.placeBlock(reader, leafPosBase.m_142082_(x, 0, z), leafBlock);
                }
            }
            if (rand.nextBoolean()) {
                leafPosBase = leafPosBase.m_7494_();
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (Math.abs(x * z) >= 2) continue;
                        this.placeBlock(reader, leafPosBase.m_142082_(x, 0, z), leafBlock);
                    }
                }
            }
            leafPosBase = leafPosBase.m_7494_();
            this.placeBlock(reader, leafPosBase.m_142300_(Direction.NORTH), leafBlock);
            this.placeBlock(reader, leafPosBase.m_142300_(Direction.EAST), leafBlock);
            this.placeBlock(reader, leafPosBase.m_142300_(Direction.SOUTH), leafBlock);
            this.placeBlock(reader, leafPosBase.m_142300_(Direction.WEST), leafBlock);
            builtLeafRing = true;
        }
        this.placeBlock(reader, movablePos.m_142082_(1, -2, 0), leafBlock);
        this.placeBlock(reader, movablePos.m_142082_(0, -2, 1), leafBlock);
        this.placeBlock(reader, movablePos.m_142082_(0, -2, -1), leafBlock);
        this.placeBlock(reader, movablePos.m_142082_(-1, -2, 0), leafBlock);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                this.placeBlock(reader, movablePos.m_142082_(x, -1, z), leafBlock);
                this.placeBlock(reader, movablePos.m_142082_(x, 1, z), leafBlock);
            }
        }
        boolean cornerLeaves = rand.nextBoolean();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (!cornerLeaves && Math.abs(x * z) == 4) continue;
                this.placeBlock(reader, movablePos.m_142082_(x, 0, z), leafBlock);
            }
        }
        this.placeBlock(reader, movablePos.m_142082_(0, 2, 0), leafBlock);
        return true;
    }

    private boolean generateTree2(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int y;
        int trunkHeight = 7 + rand.nextInt(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = Blocks.f_49999_.m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        movablePos.m_122173_(Direction.DOWN);
        for (int x = -3; x <= 3; ++x) {
            for (y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    int z2;
                    int y2;
                    int x2 = Math.abs(x);
                    int max = Math.max(x2, Math.max(y2 = Math.abs(y), z2 = Math.abs(z)));
                    if (!(max == 3 && x2 + y2 + z2 == 3 || max == 2 && x2 + y2 + z2 < 4) && max != 1) continue;
                    this.placeBlock(reader, movablePos.m_142082_(x, y, z), leafBlock);
                }
            }
        }
        int leafDrop = 2 + rand.nextInt(3);
        for (y = 1; y <= leafDrop; ++y) {
            this.placeBlock(reader, movablePos.m_142082_(3, -y, 0), leafBlock);
            this.placeBlock(reader, movablePos.m_142082_(-3, -y, 0), leafBlock);
            this.placeBlock(reader, movablePos.m_142082_(0, -y, 3), leafBlock);
            this.placeBlock(reader, movablePos.m_142082_(0, -y, -3), leafBlock);
        }
        return true;
    }

    private boolean generateTree3(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int trunkHeight = 5 + rand.nextInt(4);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 8, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = Blocks.f_49999_.m_49966_();
        BlockState barkLog = Blocks.f_50011_.m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        this.placeBlock(reader, (BlockPos)movablePos, barkLog);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int y;
            int x;
            BlockPos.MutableBlockPos branchMovablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)movablePos);
            ArrayList<Direction> availableDirections = new ArrayList<Direction>(5);
            for (Direction dir : Direction.values()) {
                if (dir == direction) continue;
                availableDirections.add(dir);
            }
            this.placeBlock(reader, (BlockPos)branchMovablePos.m_122173_(direction), barkLog);
            Direction branchDir = direction;
            for (int i = 0; i <= 3; ++i) {
                branchDir = rand.nextBoolean() ? (Direction)availableDirections.get(rand.nextInt(5)) : branchDir;
                availableDirections.clear();
                for (Direction dir : Direction.values()) {
                    if (dir == branchDir) continue;
                    availableDirections.add(dir);
                }
                this.placeBlock(reader, (BlockPos)branchMovablePos.m_122173_(branchDir), barkLog);
            }
            this.placeBlock(reader, branchMovablePos.m_142082_(0, 1, 0), log);
            this.placeBlock(reader, branchMovablePos.m_142082_(0, 2, 0), log);
            if (rand.nextBoolean()) {
                for (x = -1; x <= 1; ++x) {
                    for (y = 1; y <= 4; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(reader, branchMovablePos.m_142082_(x, y, z), leafBlock);
                        }
                    }
                }
                this.placeBlock(reader, branchMovablePos.m_142082_(0, 5, 0), leafBlock);
                this.placeBlock(reader, branchMovablePos.m_142082_(2, 2, 0), leafBlock);
                this.placeBlock(reader, branchMovablePos.m_142082_(-2, 2, 0), leafBlock);
                this.placeBlock(reader, branchMovablePos.m_142082_(0, 2, 2), leafBlock);
                this.placeBlock(reader, branchMovablePos.m_142082_(0, 2, -2), leafBlock);
                this.placeBlock(reader, branchMovablePos.m_142082_(2, 3, 0), leafBlock);
                this.placeBlock(reader, branchMovablePos.m_142082_(-2, 3, 0), leafBlock);
                this.placeBlock(reader, branchMovablePos.m_142082_(0, 3, 2), leafBlock);
                this.placeBlock(reader, branchMovablePos.m_142082_(0, 3, -2), leafBlock);
                continue;
            }
            for (x = -1; x <= 1; ++x) {
                for (y = 1; y <= 3; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        this.placeBlock(reader, branchMovablePos.m_142082_(x, y, z), leafBlock);
                    }
                }
            }
            this.placeBlock(reader, branchMovablePos.m_142082_(0, 4, 0), leafBlock);
            this.placeBlock(reader, branchMovablePos.m_142082_(2, 2, 0), leafBlock);
            this.placeBlock(reader, branchMovablePos.m_142082_(-2, 2, 0), leafBlock);
            this.placeBlock(reader, branchMovablePos.m_142082_(0, 2, 2), leafBlock);
            this.placeBlock(reader, branchMovablePos.m_142082_(0, 2, -2), leafBlock);
        }
        return true;
    }

    private boolean generateTree4(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int x;
        int z;
        int trunkHeight = 7 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 4, 2, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 2, isWorldGen)) {
            return false;
        }
        BlockState baseSoil = reader.m_8055_(pos.m_7495_());
        for (int x2 = 0; x2 < 2; ++x2) {
            for (int z2 = 0; z2 < 2; ++z2) {
                BlockPos testPos = pos.m_142082_(x2, -1, z2);
                if (!reader.m_8055_(testPos).m_60713_(Blocks.f_50016_)) continue;
                reader.m_7731_(testPos, baseSoil, 2);
            }
        }
        BlockState log = Blocks.f_49999_.m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            for (int x3 = 0; x3 <= 1; ++x3) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x3, i, z), log);
                }
            }
        }
        pos = pos.m_6630_(trunkHeight - 3);
        boolean thickBranch = rand.nextBoolean();
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if ((z == -1 || z == 2) && (x == -1 || x == 2)) continue;
                this.placeBlock(reader, pos.m_142082_(x, 0, z), log);
                if (!thickBranch) continue;
                this.placeBlock(reader, pos.m_142082_(x, 1, z), log);
            }
        }
        this.placeBlock(reader, pos.m_142082_(-2, 1, 0), log);
        this.placeBlock(reader, pos.m_142082_(-2, 1, 1), log);
        this.placeBlock(reader, pos.m_142082_(0, 1, -2), log);
        this.placeBlock(reader, pos.m_142082_(1, 1, -2), log);
        this.placeBlock(reader, pos.m_142082_(0, 1, 3), log);
        this.placeBlock(reader, pos.m_142082_(1, 1, 3), log);
        this.placeBlock(reader, pos.m_142082_(3, 1, 0), log);
        this.placeBlock(reader, pos.m_142082_(3, 1, 1), log);
        for (x = -3; x <= 4; ++x) {
            for (z = -3; z <= 4; ++z) {
                if ((x < -1 || x > 2) && (z < -1 || z > 2)) continue;
                this.placeBlock(reader, pos.m_142082_(x, 1, z), leafBlock);
                if ((x == 0 || x == 1) && z > -3 && z <= 3 || (z == 0 || z == 1) && x > -3 && x <= 3) continue;
                int x2 = x;
                int z2 = z;
                x2 = x <= 0 ? --x2 : ++x2;
                z2 = z <= 0 ? --z2 : ++z2;
                this.placeBlock(reader, pos.m_142082_(x2, 0, z2), leafBlock);
            }
        }
        this.placeBlock(reader, pos.m_142082_(-4, 0, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(-4, 0, 1), leafBlock);
        this.placeBlock(reader, pos.m_142082_(5, 0, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(5, 0, 1), leafBlock);
        this.placeBlock(reader, pos.m_142082_(0, 0, -4), leafBlock);
        this.placeBlock(reader, pos.m_142082_(1, 0, -4), leafBlock);
        this.placeBlock(reader, pos.m_142082_(0, 0, 5), leafBlock);
        this.placeBlock(reader, pos.m_142082_(1, 0, 5), leafBlock);
        for (x = 0; x <= 1; ++x) {
            for (z = -2; z <= 3; ++z) {
                this.placeBlock(reader, pos.m_142082_(x, 2, z), leafBlock);
            }
        }
        this.placeBlock(reader, pos.m_142082_(-2, 2, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(-1, 2, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(-2, 2, 1), leafBlock);
        this.placeBlock(reader, pos.m_142082_(-1, 2, 1), leafBlock);
        this.placeBlock(reader, pos.m_142082_(3, 2, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(2, 2, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(3, 2, 1), leafBlock);
        this.placeBlock(reader, pos.m_142082_(2, 2, 1), leafBlock);
        this.placeBlock(reader, pos.m_142082_(0, 3, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(0, 3, 1), leafBlock);
        this.placeBlock(reader, pos.m_142082_(1, 3, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(1, 3, 1), leafBlock);
        return true;
    }

    private boolean generateTree5(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int z;
        int x;
        int z2;
        int trunkHeight = 20 + rand.nextInt(15);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 2, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 2, isWorldGen)) {
            return false;
        }
        BlockState baseSoil = reader.m_8055_(pos.m_7495_());
        for (int x2 = 0; x2 < 2; ++x2) {
            for (int z3 = 0; z3 < 2; ++z3) {
                BlockPos testPos = pos.m_142082_(x2, -1, z3);
                if (!reader.m_8055_(testPos).m_60713_(Blocks.f_50016_)) continue;
                reader.m_7731_(testPos, baseSoil, 2);
            }
        }
        BlockState log = Blocks.f_49999_.m_49966_();
        int leafRingGap = 0;
        for (int i = 0; i < trunkHeight; ++i) {
            int x2;
            for (int x3 = 0; x3 <= 1; ++x3) {
                for (int z4 = 0; z4 <= 1; ++z4) {
                    this.placeBlock(reader, pos.m_142082_(x3, i, z4), log);
                }
            }
            if (++leafRingGap <= 5 || i >= trunkHeight - 6 || rand.nextInt(5) != 0) continue;
            if (rand.nextBoolean()) {
                leafRingGap = 0;
                for (x2 = -1; x2 <= 2; ++x2) {
                    for (z2 = -1; z2 <= 2; ++z2) {
                        this.placeBlock(reader, pos.m_142082_(x2, i, z2), leafBlock);
                        this.placeBlock(reader, pos.m_142082_(x2, i + 2, z2), leafBlock);
                    }
                }
                for (x2 = -2; x2 <= 3; ++x2) {
                    for (z2 = -2; z2 <= 3; ++z2) {
                        this.placeBlock(reader, pos.m_142082_(x2, i + 1, z2), leafBlock);
                    }
                }
                continue;
            }
            leafRingGap = -2;
            for (x2 = -1; x2 <= 2; ++x2) {
                for (z2 = -1; z2 <= 2; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x2, i, z2), leafBlock);
                    this.placeBlock(reader, pos.m_142082_(x2, i + 4, z2), leafBlock);
                }
            }
            for (x2 = -2; x2 <= 3; ++x2) {
                for (z2 = -2; z2 <= 3; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x2, i + 1, z2), leafBlock);
                    this.placeBlock(reader, pos.m_142082_(x2, i + 3, z2), leafBlock);
                }
            }
            for (x2 = -3; x2 <= 4; ++x2) {
                for (z2 = -3; z2 <= 4; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x2, i + 2, z2), leafBlock);
                }
            }
        }
        pos = pos.m_6630_(trunkHeight - 3);
        for (x = -4; x <= 5; ++x) {
            for (z = 0; z <= 1; ++z) {
                this.placeBlock(reader, pos.m_142082_(x, 0, z), leafBlock);
                this.placeBlock(reader, pos.m_142082_(x, 4, z), leafBlock);
                if (x != 0 && x != 1 || z != 0) continue;
                for (z2 = -4; z2 < 0; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x, 0, z2), leafBlock);
                    this.placeBlock(reader, pos.m_142082_(x, 4, z2), leafBlock);
                }
                for (z2 = 2; z2 < 6; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x, 0, z2), leafBlock);
                    this.placeBlock(reader, pos.m_142082_(x, 4, z2), leafBlock);
                }
            }
        }
        for (x = -5; x <= 6; ++x) {
            for (z = -1; z <= 2; ++z) {
                this.placeBlock(reader, pos.m_142082_(x, 1, z), leafBlock);
                this.placeBlock(reader, pos.m_142082_(x, 3, z), leafBlock);
                if (x < -1 || x > 2 || z != 0) continue;
                for (z2 = -5; z2 < 0; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x, 1, z2), leafBlock);
                    this.placeBlock(reader, pos.m_142082_(x, 3, z2), leafBlock);
                }
                for (z2 = 3; z2 < 7; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x, 1, z2), leafBlock);
                    this.placeBlock(reader, pos.m_142082_(x, 3, z2), leafBlock);
                }
            }
        }
        for (x = -6; x <= 7; ++x) {
            for (z = -2; z <= 3; ++z) {
                this.placeBlock(reader, pos.m_142082_(x, 2, z), leafBlock);
                if (x < -2 || x > 3 || z != 0) continue;
                for (z2 = -6; z2 < 0; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x, 2, z2), leafBlock);
                }
                for (z2 = 4; z2 < 8; ++z2) {
                    this.placeBlock(reader, pos.m_142082_(x, 2, z2), leafBlock);
                }
            }
        }
        return true;
    }

    private boolean generateTree6(WorldGenLevel reader, Random rand, BlockPos pos, BlockState leafBlock, boolean isWorldGen) {
        int z;
        int x;
        int trunkHeight = 15 + rand.nextInt(8);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 4, 2, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 2, isWorldGen)) {
            return false;
        }
        BlockState log = Blocks.f_49999_.m_49966_();
        int leafRingGap = -1;
        for (int i = 0; i < trunkHeight; ++i) {
            int z2;
            int x2;
            for (x = 0; x <= 1; ++x) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x, i, z), log);
                }
            }
            if (++leafRingGap <= 3 || i >= trunkHeight - 7 || !rand.nextBoolean()) continue;
            leafRingGap = 0;
            int ringWidth = 2 + rand.nextInt(3);
            boolean fullTopRing = rand.nextBoolean();
            boolean fullBottomRing = rand.nextBoolean();
            for (x2 = -1; x2 <= 2; ++x2) {
                for (z2 = -1; z2 <= 2; ++z2) {
                    if (fullTopRing || x2 == 0 || x2 == 1 || z2 == 0 || z2 == 1) {
                        this.placeBlock(reader, pos.m_142082_(x2, i + 2, z2), leafBlock);
                    }
                    if (!fullBottomRing && x2 != 0 && x2 != 1 && z2 != 0 && z2 != 1) continue;
                    this.placeBlock(reader, pos.m_142082_(x2, i, z2), leafBlock);
                }
            }
            for (x2 = -ringWidth; x2 <= ringWidth + 1; ++x2) {
                for (z2 = -ringWidth; z2 <= ringWidth + 1; ++z2) {
                    int x3 = x2;
                    int z3 = z2;
                    if (x3 < 0) {
                        --x3;
                    }
                    if (z3 < 0) {
                        --z3;
                    }
                    if (Math.abs(x3) > ringWidth - (Math.abs(z3) - 3)) continue;
                    this.placeBlock(reader, pos.m_142082_(x2, i + 1, z2), leafBlock);
                }
            }
        }
        pos = pos.m_6630_(trunkHeight - 3);
        boolean fullRing = rand.nextBoolean();
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if (!fullRing && x != 0 && x != 1 && z != 0 && z != 1) continue;
                this.placeBlock(reader, pos.m_142082_(x, 0, z), leafBlock);
            }
        }
        for (int i = 4; i > 0; --i) {
            for (int x2 = -i; x2 <= i + 1; ++x2) {
                for (int z2 = -i; z2 <= i + 1; ++z2) {
                    int x3 = x2;
                    int z3 = z2;
                    if (x3 < 0) {
                        --x3;
                    }
                    if (z3 < 0) {
                        --z3;
                    }
                    if (Math.abs(x3) > i - (Math.abs(z3) - 3)) continue;
                    this.placeBlock(reader, pos.m_142082_(x2, 5 - i, z2), leafBlock);
                }
            }
        }
        this.placeBlock(reader, pos.m_142082_(0, 5, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(1, 5, 0), leafBlock);
        this.placeBlock(reader, pos.m_142082_(0, 5, 1), leafBlock);
        this.placeBlock(reader, pos.m_142082_(1, 5, 1), leafBlock);
        return true;
    }
}

