/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class InvertedAchonyTreeFeature
extends AoATreeFeature {
    public InvertedAchonyTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean checkSafeHeight(WorldGenLevel reader, BlockPos pos, int maxHeight, int trunkWidth, boolean isWorldGen) {
        return pos.m_123342_() <= 256 && pos.m_123342_() - maxHeight >= 1;
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int coreHeight;
        int trunkHeight = 20 + rand.nextInt(10);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + (int)((float)(coreHeight = 4 + rand.nextInt(3)) * 1.5f), 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7494_());
        BlockState log = ((Block)AoABlocks.ACHONY_LOG.get()).m_49966_();
        boolean lastRowRinged = false;
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.DOWN), log);
            if (i >= 3 && rand.nextFloat() < 0.4f && !lastRowRinged) {
                this.buildLeafRing(reader, movablePos.m_7949_());
                lastRowRinged = true;
                continue;
            }
            lastRowRinged = false;
        }
        this.buildCrown(reader, movablePos.m_7949_(), coreHeight);
        return true;
    }

    private void buildCrown(WorldGenLevel reader, BlockPos pos, int coreHeight) {
        int x;
        BlockState achonyLeaves = ((Block)AoABlocks.ACHONY_LEAVES.get()).m_49966_();
        BlockState lelyetianLeaves = ((Block)AoABlocks.LELYETIAN_LEAVES.get()).m_49966_();
        this.buildLeafRing(reader, pos.m_6630_(1));
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                this.placeBlock(reader, pos.m_142082_(x, 0, z), achonyLeaves);
            }
        }
        for (x = -3; x <= 3; ++x) {
            this.placeBlock(reader, pos.m_142082_(x, -1, -3), achonyLeaves);
            this.placeBlock(reader, pos.m_142082_(x, -1, 3), achonyLeaves);
        }
        for (int z = -2; z <= 2; ++z) {
            this.placeBlock(reader, pos.m_142082_(3, -1, z), achonyLeaves);
            this.placeBlock(reader, pos.m_142082_(-3, -1, z), achonyLeaves);
        }
        this.placeBlock(reader, pos.m_142082_(3, -2, 2), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(3, -2, 3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(3, -2, -2), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(3, -2, -3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(-3, -2, 2), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(-3, -2, 3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(-3, -2, -2), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(-3, -2, -3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(2, -2, 3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(-2, -2, 3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(2, -2, -3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(-2, -2, -3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(3, -3, 3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(-3, -3, -3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(-3, -3, 3), achonyLeaves);
        this.placeBlock(reader, pos.m_142082_(3, -3, -3), achonyLeaves);
        for (x = -1; x <= 1; ++x) {
            for (int y = 0; y <= coreHeight; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x, -y, z), lelyetianLeaves);
                }
            }
        }
        for (int y = coreHeight; y <= (int)((double)coreHeight * 1.5); ++y) {
            this.placeBlock(reader, pos.m_142082_(0, -y, 0), lelyetianLeaves);
        }
    }

    private void buildLeafRing(WorldGenLevel reader, BlockPos pos) {
        BlockState achonyLeaves = ((Block)AoABlocks.ACHONY_LEAVES.get()).m_49966_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                this.placeBlock(reader, pos.m_142082_(x, 0, z), achonyLeaves);
            }
        }
    }
}

