/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class IrogoldTreeFeature
extends AoATreeFeature {
    public IrogoldTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        BlockPos multiSaplingPos = this.findMultiSaplingPosition(reader, rand, pos, 2, isWorldGen);
        if (isWorldGen && rand.nextBoolean() || multiSaplingPos == null) {
            return this.generateTree1(reader, rand, pos, isWorldGen);
        }
        return this.generateTree2(reader, rand, multiSaplingPos, isWorldGen);
    }

    private boolean generateTree1(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 7 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.IROLOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.IROGOLD_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        for (int x = -3; x <= 3; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    if (Math.abs(x) >= 4 - y - Math.abs(z) && Math.abs(z) >= 4 - y - Math.abs(x)) continue;
                    this.placeBlock(reader, movablePos.m_142082_(x, y, z), leaves);
                }
            }
        }
        this.placeBlock(reader, movablePos.m_142082_(0, -1, 1), leaves);
        this.placeBlock(reader, movablePos.m_142082_(0, -1, -1), leaves);
        this.placeBlock(reader, movablePos.m_142082_(1, -1, 0), leaves);
        this.placeBlock(reader, movablePos.m_142082_(-1, -1, 0), leaves);
        return true;
    }

    private boolean generateTree2(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 7 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 2, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 2, isWorldGen)) {
            return false;
        }
        BlockState baseSoil = reader.m_8055_(pos.m_7495_());
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                BlockPos testPos = pos.m_142082_(x, -1, z);
                if (!reader.m_8055_(testPos).m_60713_(Blocks.f_50016_)) continue;
                reader.m_7731_(testPos, baseSoil, 2);
            }
        }
        BlockState log = ((Block)AoABlocks.IROLOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.IROGOLD_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x, i, z), log);
                }
            }
        }
        pos = pos.m_6630_(trunkHeight - 1);
        int branchWidth = 2 + rand.nextInt(3);
        for (int i = 1; i <= branchWidth; ++i) {
            for (int j = -1; j <= 1; j += 2) {
                int i2 = (j < 0 ? i - 1 : i) * j;
                this.placeBlock(reader, pos.m_142082_(i2, 0, 0), log);
                this.placeBlock(reader, pos.m_142082_(i2, 0, 1), log);
                this.placeBlock(reader, pos.m_142082_(0, 0, i2), log);
                this.placeBlock(reader, pos.m_142082_(1, 0, i2), log);
                if (i != branchWidth) continue;
                for (Direction dir : Direction.values()) {
                    BlockPos leafPos = pos.m_142300_(dir);
                    this.placeBlock(reader, leafPos.m_142082_(i2, 0, 0), leaves);
                    this.placeBlock(reader, leafPos.m_142082_(i2, 0, 1), leaves);
                    this.placeBlock(reader, leafPos.m_142082_(0, 0, i2), leaves);
                    this.placeBlock(reader, leafPos.m_142082_(1, 0, i2), leaves);
                }
            }
        }
        return true;
    }
}

