/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class LuniciaTreeFeature
extends AoATreeFeature {
    public LuniciaTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        if (rand.nextBoolean()) {
            return this.generateTree1(reader, rand, pos, isWorldGen);
        }
        return this.generateTree2(reader, rand, pos, isWorldGen);
    }

    private boolean generateTree1(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 6 + rand.nextInt(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.LUNIDE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.LUNICIA_LEAVES.get()).m_49966_();
        int leafGap = -1;
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
            if (leafGap >= 2 && rand.nextFloat() < 0.65f) {
                leafGap = 0;
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        if (Math.abs(x) != 2 && Math.abs(z) != 2) continue;
                        this.placeBlock(reader, movablePos.m_142082_(x, 0, z), leaves);
                    }
                }
            }
            ++leafGap;
        }
        return true;
    }

    private boolean generateTree2(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 6 + rand.nextInt(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.LUNIDE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.LUNICIA_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        int leafPillars = 2 + rand.nextInt(5);
        for (double i = 0.0; i < Math.PI * 2; i += Math.PI / (double)leafPillars) {
            int x = (int)Math.round(Math.cos(i) * 2.0);
            int z = (int)Math.round(Math.sin(i) * 2.0);
            int initY = rand.nextInt(2);
            int endY = rand.nextInt(2);
            for (int y = initY; y <= trunkHeight - 3 - endY; ++y) {
                this.placeBlock(reader, movablePos.m_142082_(x, -y, z), leaves);
            }
        }
        return true;
    }
}

