/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.teleporter;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;

public class AoAPortalFrame {
    private static final ArrayList<Vec3i> northSouthPattern = new ArrayList();
    private static final ArrayList<Vec3i> eastWestPattern = new ArrayList();

    public static PortalDirection testFrameForActivation(Level world, BlockPos activationPos, Direction sideClicked, PortalBlock portalBlock) {
        switch (sideClicked) {
            case NORTH: 
            case SOUTH: {
                return AoAPortalFrame.testNorthSouthPortalFrame(world, activationPos, portalBlock);
            }
            case EAST: 
            case WEST: {
                return AoAPortalFrame.testEastWestPortalFrame(world, activationPos, portalBlock);
            }
        }
        PortalDirection dir = AoAPortalFrame.testNorthSouthPortalFrame(world, activationPos, portalBlock);
        if (dir == PortalDirection.INVALID) {
            dir = AoAPortalFrame.testEastWestPortalFrame(world, activationPos, portalBlock);
        }
        return dir;
    }

    public static PortalDirection testNorthSouthPortalFrame(Level world, BlockPos basePos, PortalBlock portalBlock) {
        Block carvedRuneTravel = null;
        Block carvedRuneReality = null;
        Block carvedRuneSpace = null;
        Block carvedRuneDirection = null;
        int ancientRockCount = 0;
        for (Vec3i pos : northSouthPattern) {
            BlockState testState = world.m_8055_(basePos.m_141952_(pos));
            Block testBlock = testState.m_60734_();
            if (testBlock == AoABlocks.ANCIENT_ROCK.get()) {
                ++ancientRockCount;
                continue;
            }
            if (!testState.m_204336_(AoATags.Blocks.CARVED_RUNE)) continue;
            if (testBlock == AoABlocks.CARVED_RUNE_OF_TRAVEL.get()) {
                if (carvedRuneTravel != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneTravel = testBlock;
                continue;
            }
            if (testBlock == AoABlocks.CARVED_RUNE_OF_REALITY.get()) {
                if (carvedRuneReality != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneReality = testBlock;
                continue;
            }
            if (testBlock == AoABlocks.CARVED_RUNE_OF_SPACE.get()) {
                if (carvedRuneSpace != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneSpace = testBlock;
                continue;
            }
            if (testBlock != AoABlocks.CARVED_RUNE_OF_DIRECTION.get()) continue;
            if (carvedRuneDirection != null) {
                return PortalDirection.INVALID;
            }
            carvedRuneDirection = testBlock;
        }
        if (ancientRockCount == 13 && carvedRuneDirection != null && carvedRuneReality != null && carvedRuneSpace != null && carvedRuneTravel != null) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 1; y < 5; ++y) {
                    BlockState state = world.m_8055_(basePos.m_142082_(x, y, 0));
                    if (state.m_60734_() instanceof PortalBlock) {
                        if (state.m_60734_() != portalBlock) continue;
                        return PortalDirection.EXISTING;
                    }
                    if (state.m_60767_().m_76336_()) continue;
                    return PortalDirection.INVALID;
                }
            }
            return PortalDirection.NORTH_SOUTH;
        }
        return PortalDirection.INVALID;
    }

    public static PortalDirection testEastWestPortalFrame(Level world, BlockPos basePos, PortalBlock portalBlock) {
        Block carvedRuneTravel = null;
        Block carvedRuneReality = null;
        Block carvedRuneSpace = null;
        Block carvedRuneDirection = null;
        int ancientRockCount = 0;
        for (Vec3i pos : eastWestPattern) {
            BlockState testState = world.m_8055_(basePos.m_141952_(pos));
            Block testBlock = testState.m_60734_();
            if (testBlock == AoABlocks.ANCIENT_ROCK.get()) {
                ++ancientRockCount;
                continue;
            }
            if (!testState.m_204336_(AoATags.Blocks.CARVED_RUNE)) continue;
            if (testBlock == AoABlocks.CARVED_RUNE_OF_TRAVEL.get()) {
                if (carvedRuneTravel != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneTravel = testBlock;
                continue;
            }
            if (testBlock == AoABlocks.CARVED_RUNE_OF_REALITY.get()) {
                if (carvedRuneReality != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneReality = testBlock;
                continue;
            }
            if (testBlock == AoABlocks.CARVED_RUNE_OF_SPACE.get()) {
                if (carvedRuneSpace != null) {
                    return PortalDirection.INVALID;
                }
                carvedRuneSpace = testBlock;
                continue;
            }
            if (testBlock != AoABlocks.CARVED_RUNE_OF_DIRECTION.get()) continue;
            if (carvedRuneDirection != null) {
                return PortalDirection.INVALID;
            }
            carvedRuneDirection = testBlock;
        }
        if (ancientRockCount == 13 && carvedRuneDirection != null && carvedRuneReality != null && carvedRuneSpace != null && carvedRuneTravel != null) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 1; y < 5; ++y) {
                    BlockState state = world.m_8055_(basePos.m_142082_(0, y, z));
                    if (state.m_60734_() instanceof PortalBlock) {
                        if (state.m_60734_() != portalBlock) continue;
                        return PortalDirection.EXISTING;
                    }
                    if (state.m_60767_().m_76336_()) continue;
                    return PortalDirection.INVALID;
                }
            }
            return PortalDirection.EAST_WEST;
        }
        return PortalDirection.INVALID;
    }

    public static void lightPortalFrame(Level world, BlockPos basePos, PortalDirection direction, PortalBlock portalBlock) {
        switch (direction) {
            case NORTH_SOUTH: {
                for (int x = -1; x < 2; ++x) {
                    for (int y = 1; y < 5; ++y) {
                        world.m_7731_(basePos.m_142082_(x, y, 0), (BlockState)portalBlock.m_49966_().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z), 2);
                    }
                }
                break;
            }
            case EAST_WEST: {
                for (int z = -1; z < 2; ++z) {
                    for (int y = 1; y < 5; ++y) {
                        world.m_7731_(basePos.m_142082_(0, y, z), portalBlock.m_49966_(), 2);
                    }
                }
                break;
            }
        }
    }

    static {
        northSouthPattern.add(new Vec3i(-2, 0, 0));
        northSouthPattern.add(new Vec3i(-1, 0, 0));
        northSouthPattern.add(new Vec3i(0, 0, 0));
        northSouthPattern.add(new Vec3i(1, 0, 0));
        northSouthPattern.add(new Vec3i(2, 0, 0));
        northSouthPattern.add(new Vec3i(2, 1, 0));
        northSouthPattern.add(new Vec3i(2, 2, 0));
        northSouthPattern.add(new Vec3i(2, 3, 0));
        northSouthPattern.add(new Vec3i(2, 4, 0));
        northSouthPattern.add(new Vec3i(2, 5, 0));
        northSouthPattern.add(new Vec3i(1, 5, 0));
        northSouthPattern.add(new Vec3i(0, 5, 0));
        northSouthPattern.add(new Vec3i(-1, 5, 0));
        northSouthPattern.add(new Vec3i(-2, 5, 0));
        northSouthPattern.add(new Vec3i(-2, 4, 0));
        northSouthPattern.add(new Vec3i(-2, 3, 0));
        northSouthPattern.add(new Vec3i(-2, 2, 0));
        northSouthPattern.add(new Vec3i(-2, 1, 0));
        eastWestPattern.add(new Vec3i(0, 0, -2));
        eastWestPattern.add(new Vec3i(0, 0, -1));
        eastWestPattern.add(new Vec3i(0, 0, 0));
        eastWestPattern.add(new Vec3i(0, 0, 1));
        eastWestPattern.add(new Vec3i(0, 0, 2));
        eastWestPattern.add(new Vec3i(0, 1, 2));
        eastWestPattern.add(new Vec3i(0, 2, 2));
        eastWestPattern.add(new Vec3i(0, 3, 2));
        eastWestPattern.add(new Vec3i(0, 4, 2));
        eastWestPattern.add(new Vec3i(0, 5, 2));
        eastWestPattern.add(new Vec3i(0, 5, 1));
        eastWestPattern.add(new Vec3i(0, 5, 0));
        eastWestPattern.add(new Vec3i(0, 5, -1));
        eastWestPattern.add(new Vec3i(0, 5, -2));
        eastWestPattern.add(new Vec3i(0, 4, -2));
        eastWestPattern.add(new Vec3i(0, 3, -2));
        eastWestPattern.add(new Vec3i(0, 2, -2));
        eastWestPattern.add(new Vec3i(0, 1, -2));
    }

    public static enum PortalDirection {
        INVALID,
        EXISTING,
        NORTH_SOUTH,
        EAST_WEST;

    }
}

