/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.crafttweaker.util;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import org.apache.logging.log4j.Level;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.aoa3.PlayerData")
public class CTPlayerData {
    private ServerPlayerDataManager plData;
    private final UUID backupPlayerUUID;

    public CTPlayerData(ServerPlayerDataManager plData) {
        this.plData = plData;
        this.backupPlayerUUID = plData.player().m_142081_();
    }

    @Nullable
    public static CTPlayerData getForPlayer(Player player) {
        if (player.f_19853_.m_5776_()) {
            return null;
        }
        return new CTPlayerData(PlayerUtil.getAdventPlayer((ServerPlayer)player));
    }

    @ZenCodeType.Method
    public int getLevel(String skillId, @ZenCodeType.OptionalBoolean boolean ignoreLevelCap) {
        if (!this.validatePlayerData()) {
            return 0;
        }
        AoASkill skill = AoASkills.getSkill(new ResourceLocation(skillId));
        if (skill == null) {
            Logging.logMessage(Level.WARN, "Invalid skill name: " + skillId + " for CraftTweaker method.");
            return -1;
        }
        return this.plData.getSkill(skill).getLevel(ignoreLevelCap);
    }

    @ZenCodeType.Method
    public float getXp(String skillId) {
        if (!this.validatePlayerData()) {
            return 0.0f;
        }
        AoASkill skill = AoASkills.getSkill(new ResourceLocation(skillId));
        if (skill == null) {
            Logging.logMessage(Level.WARN, "Invalid skill name: " + skillId + " for CraftTweaker method.");
            return -1.0f;
        }
        return this.plData.getSkill(skill).getXp();
    }

    @ZenCodeType.Method
    public void grantXp(String skillId, float xpAmount) {
        if (!this.validatePlayerData()) {
            return;
        }
        AoASkill skill = AoASkills.getSkill(new ResourceLocation(skillId));
        if (skill == null) {
            Logging.logMessage(Level.WARN, "Invalid skill name: " + skillId + " for CraftTweaker method.");
            return;
        }
        this.plData.getSkill(skill).adjustXp(xpAmount, false, false);
    }

    @ZenCodeType.Method
    public float getResourceValue(String resourceId) {
        if (!this.validatePlayerData()) {
            return -1.0f;
        }
        AoAResource resource = AoAResources.getResource(new ResourceLocation(resourceId));
        if (resource == null) {
            Logging.logMessage(Level.ERROR, "Invalid resource name: " + resourceId + " for CraftTweaker method.");
            return -1.0f;
        }
        return this.plData.getResource(resource).getCurrentValue();
    }

    @ZenCodeType.Method
    public void grantResource(String resourceId, float amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        AoAResource resource = AoAResources.getResource(new ResourceLocation(resourceId));
        if (resource == null) {
            Logging.logMessage(Level.ERROR, "Invalid resource name: " + resourceId + " for CraftTweaker method.");
            return;
        }
        this.plData.getResource(resource).addValue(amount);
    }

    @ZenCodeType.Method
    public boolean consumeResource(String resourceId, float amount, boolean forceConsume) {
        if (!this.validatePlayerData()) {
            return false;
        }
        AoAResource resource = AoAResources.getResource(new ResourceLocation(resourceId));
        if (resource == null) {
            Logging.logMessage(Level.ERROR, "Invalid resource name: " + resourceId + " for CraftTweaker method.");
            return false;
        }
        return this.plData.getResource(resource).consume(amount, forceConsume);
    }

    @ZenCodeType.Method
    public void addSkillXpModifier(String skillId, float amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        AoASkill skill = AoASkills.getSkill(new ResourceLocation(skillId));
        if (skill == null) {
            Logging.logMessage(Level.ERROR, "Invalid skill ID: " + skillId + " for CraftTweaker method.");
            return;
        }
        this.plData.getSkill(skill).applyXpModifier(amount);
    }

    @ZenCodeType.Method
    public void removeSkillXpModifier(String skillId, float amount) {
        if (!this.validatePlayerData()) {
            return;
        }
        AoASkill skill = AoASkills.getSkill(new ResourceLocation(skillId));
        if (skill == null) {
            Logging.logMessage(Level.ERROR, "Invalid skill ID: " + skillId + " for CraftTweaker method.");
            return;
        }
        this.plData.getSkill(skill).removeXpModifier(amount);
    }

    @ZenCodeType.Getter
    public IItemStack getArmourSetType() {
        if (!this.validatePlayerData()) {
            return (IItemStack)MCItemStack.EMPTY.get();
        }
        if (this.plData.equipment().getCurrentFullArmourSet() == null) {
            return (IItemStack)MCItemStack.EMPTY.get();
        }
        return new MCItemStack(new ItemStack((ItemLike)this.plData.player().m_6844_(EquipmentSlot.FEET).m_41720_()));
    }

    private boolean validatePlayerData() {
        if (this.plData == null || this.plData.player() == null || !this.plData.player().m_6084_()) {
            if (this.backupPlayerUUID == null) {
                return false;
            }
            ServerPlayer pl = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.backupPlayerUUID);
            if (pl == null) {
                return false;
            }
            this.plData = PlayerUtil.getAdventPlayer(pl);
        }
        return true;
    }
}

