/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.tinkersconstruct.modifier;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.ToolActions;
import net.tslat.aoa3.util.EntityUtil;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.RomanNumeralHelper;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class AirBladeModifier
extends Modifier {
    public Component getDisplayName(int level) {
        return this.applyStyle(new TranslatableComponent(this.getTranslationKey()).m_130946_(" ").m_7220_(RomanNumeralHelper.getNumeral((int)level)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFDD8))));
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        int toolDamage = super.afterEntityHit(tool, level, context, damageDealt);
        if (damageDealt > 0.0f && !tool.isBroken() && tool.getItem().canPerformAction(tool.getItem().m_7968_(), ToolActions.SWORD_SWEEP)) {
            Player player = context.getPlayerAttacker();
            if (player == null || player.f_19789_ > 0.0f || !player.m_20096_() || player.m_20142_() || player.m_6147_() || player.m_20069_() || player.m_20202_() != null) {
                return toolDamage;
            }
            if (EntityUtil.getAttackCooldown((LivingEntity)player) <= 0.9f) {
                return toolDamage;
            }
            if (player.f_19787_ - player.f_19867_ >= player.m_6113_()) {
                return toolDamage;
            }
            float damage = damageDealt * ((float)level / (float)(level + 2));
            for (LivingEntity entity : player.f_19853_.m_45976_(LivingEntity.class, context.getLivingTarget().m_142469_().m_82377_(1.0, 0.25, 1.0))) {
                if (entity == player || entity == context.getLivingTarget() || player.m_5647_() == entity.m_5647_() || !(player.m_20280_((Entity)entity) < 9.0)) continue;
                entity.m_6469_(DamageSource.m_19344_((Player)player), damage);
            }
        }
        return toolDamage;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        this.addDamageTooltip(tool, (float)level / (float)level + 2.0f - 1.0f, tooltip);
    }
}

