/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class DoubleDropsChance
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.LOOT_MODIFICATION};

    public DoubleDropsChance(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)((Object)AoAAbilities.DOUBLE_DROPS_CHANCE.get()), skill, data);
    }

    public DoubleDropsChance(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)((Object)AoAAbilities.DOUBLE_DROPS_CHANCE.get()), skill, data);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleLootModification(List<ItemStack> loot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81455_)) {
            return;
        }
        Entity killedEntity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (killedEntity instanceof Player) {
            return;
        }
        if (this.testAsChance()) {
            ArrayList<ItemStack> extras = null;
            for (ItemStack stack : loot) {
                if (stack.m_41753_()) {
                    if (stack.m_41613_() <= stack.m_41741_() / 2) {
                        stack.m_41764_(stack.m_41613_() * 2);
                        continue;
                    }
                    if (extras == null) {
                        extras = new ArrayList();
                    }
                    ItemStack newStack = stack.m_41777_();
                    newStack.m_41764_(stack.m_41613_() * 2 - newStack.m_41741_());
                    stack.m_41764_(stack.m_41741_());
                    extras.add(newStack);
                    continue;
                }
                if (extras == null) {
                    extras = new ArrayList<ItemStack>();
                }
                extras.add(stack.m_41777_());
            }
            if (extras != null) {
                loot.addAll(extras);
            }
        }
    }
}

