/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.WorldUtil;

public class HoeAreaHarvest
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.BLOCK_INTERACT};
    private final int baseRadius;
    private final int levelsPerRadiusIncrease;
    private final int perBlockHoeDamage;

    public HoeAreaHarvest(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)((Object)AoAAbilities.HOE_AREA_HARVEST.get()), skill, data);
        this.baseRadius = GsonHelper.m_13824_((JsonObject)data, (String)"base_radius", (int)1);
        this.levelsPerRadiusIncrease = GsonHelper.m_13824_((JsonObject)data, (String)"levels_per_radius_increase", (int)0);
        this.perBlockHoeDamage = GsonHelper.m_13824_((JsonObject)data, (String)"per_block_hoe_damage", (int)1);
        if (this.baseRadius < 0) {
            throw new IllegalArgumentException("Invalid radius value for BlockConversion ability: '" + this.baseRadius + "'. Must be at least 0");
        }
    }

    public HoeAreaHarvest(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)((Object)AoAAbilities.HOE_AREA_HARVEST.get()), skill, data);
        this.baseRadius = data.m_128451_("base_radius");
        this.levelsPerRadiusIncrease = data.m_128451_("levels_per_radius_increase");
        this.perBlockHoeDamage = data.m_128451_("per_block_hoe_damage");
    }

    @Override
    protected void updateDescription(TranslatableComponent defaultDescription) {
        Object suffix = this.levelsPerRadiusIncrease > 0 ? "" : ".flat";
        suffix = (String)suffix + (this.perBlockHoeDamage <= 0 ? "" : ".noDamage");
        super.updateDescription(new TranslatableComponent(defaultDescription.m_131328_() + (String)suffix, new Object[]{this.baseRadius, this.levelsPerRadiusIncrease, this.perBlockHoeDamage}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleBlockInteraction(PlayerInteractEvent.RightClickBlock ev) {
        Player player;
        ItemStack heldStack;
        if (ev.getWorld().m_8055_(ev.getPos()).m_204336_(BlockTags.f_13073_) && (heldStack = (player = ev.getPlayer()).m_21120_(ev.getHand())).m_41720_() instanceof HoeItem) {
            int radius = this.levelsPerRadiusIncrease > 0 ? this.baseRadius + (this.skill.getLevel(false) - this.getLevelReq()) / this.levelsPerRadiusIncrease : this.baseRadius;
            Level world = ev.getWorld();
            BlockPos basePos = ev.getPos();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    CropBlock crop;
                    BlockState state = world.m_8055_((BlockPos)pos.m_122178_(basePos.m_123341_() + x, basePos.m_123342_(), basePos.m_123343_() + z));
                    Block block = state.m_60734_();
                    if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).m_52307_(state) || !WorldUtil.canModifyBlock((LevelAccessor)world, (BlockPos)pos, (Entity)player, heldStack)) continue;
                    WorldUtil.harvestAdditionalBlock(world, ev.getPlayer(), (BlockPos)pos, true);
                    if (this.perBlockHoeDamage <= 0) continue;
                    ItemUtil.damageItem(heldStack, (LivingEntity)player, ev.getHand(), this.perBlockHoeDamage);
                    if (!heldStack.m_41619_()) continue;
                    return;
                }
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128405_("base_radius", this.baseRadius);
            data.m_128405_("levels_per_radius_increase", this.levelsPerRadiusIncrease);
            data.m_128405_("per_block_hoe_damage", this.perBlockHoeDamage);
        }
        return data;
    }
}

