/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class InnervationDodge
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.KEY_INPUT, AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_BEFORE};
    private final float energyCost;
    private long activationTime;

    public InnervationDodge(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)((Object)AoAAbilities.INNERVATION_DODGE.get()), skill, data);
        this.energyCost = GsonHelper.m_13915_((JsonObject)data, (String)"energy_cost");
    }

    public InnervationDodge(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)((Object)AoAAbilities.INNERVATION_DODGE.get()), skill, data);
        this.energyCost = data.m_128457_("energy_cost");
    }

    @Override
    protected void updateDescription(TranslatableComponent defaultDescription) {
        super.updateDescription(new TranslatableComponent(defaultDescription.m_131328_(), new Object[]{NumberUtil.roundToNthDecimalPlace(this.energyCost, 2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKeybind() {
        return AoAKeybinds.ABILITY_ACTION;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldSendKeyPress() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float yRot = player.m_5675_(Minecraft.m_91087_().m_91297_());
        if (player.f_108618_.f_108566_ == 0.0f || player.f_108618_.m_108577_() || player.f_19853_.m_46467_() <= this.activationTime + 5L || player.m_150110_().f_35935_) {
            return false;
        }
        if (ClientPlayerDataManager.get().getResource((AoAResource)((Object)AoAResources.ENERGY.get())).hasAmount(this.energyCost)) {
            Vec3 movement = player.m_20184_();
            double limit = player.m_20096_() ? 2.5 : 0.9;
            double velocityX = Mth.m_14008_((double)(movement.m_7096_() + (double)(Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * player.f_108618_.f_108566_)), (double)(-limit), (double)limit);
            double velocityZ = Mth.m_14008_((double)(movement.m_7094_() + (double)(Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))) * player.f_108618_.f_108566_)), (double)(-limit), (double)limit);
            player.m_20256_(new Vec3(velocityX, movement.m_7098_(), velocityZ));
            this.activationTime = player.f_19853_.m_46467_();
        }
        return true;
    }

    @Override
    public void handleKeyInput() {
        ServerPlayer player = this.getPlayer();
        if (this.skill.getPlayerDataManager().getResource((AoAResource)((Object)AoAResources.ENERGY.get())).consume(this.energyCost, true)) {
            this.activatedActionKey(player);
            if (this.skill.canGainXp(true)) {
                this.skill.adjustXp(PlayerUtil.getTimeBasedXpForLevel(this.skill.getLevel(true), 20.0f), false, false);
            }
        }
    }

    @Override
    public void handlePreIncomingAttack(LivingAttackEvent ev) {
        if (ev.getEntityLiving().f_19853_.m_46467_() < this.activationTime + 5L && DamageUtil.isMeleeDamage(ev.getSource())) {
            ev.setCanceled(true);
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("energy_cost", this.energyCost);
        }
        return data;
    }
}

