/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.UpdateClientMovementPacket;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class JumpBoost
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.PLAYER_JUMP, AoAPlayerEventListener.ListenerType.LEVEL_CHANGE};
    private final boolean sprintJumpBoost;
    private double baseBoostMultiplier;
    private double launchMultiplier;

    public JumpBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)((Object)AoAAbilities.JUMP_BOOST.get()), skill, data);
        this.sprintJumpBoost = GsonHelper.m_13855_((JsonObject)data, (String)"amplify_lateral_velocity", (boolean)false);
        this.updateMultipliers();
    }

    public JumpBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)((Object)AoAAbilities.JUMP_BOOST.get()), skill, data);
        this.sprintJumpBoost = data.m_128471_("amplify_lateral_velocity");
    }

    @Override
    protected void updateDescription(TranslatableComponent defaultDescription) {
        super.updateDescription(new TranslatableComponent(defaultDescription.m_131328_() + (this.sprintJumpBoost ? ".lateral" : ".vertical"), new Object[]{this.getScalingDescriptionComponent(2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    private void updateMultipliers() {
        this.baseBoostMultiplier = 1.0f + this.getScaledValue();
        this.launchMultiplier = -8.0E-4 * Math.pow(this.baseBoostMultiplier, 4.0) + 0.00332 * Math.pow(this.baseBoostMultiplier, 3.0) - 0.05499 * Math.pow(this.baseBoostMultiplier, 2.0) + 0.62043 * this.baseBoostMultiplier + 0.27697;
    }

    @Override
    public void handleLevelChange(PlayerLevelChangeEvent ev) {
        this.updateMultipliers();
    }

    @Override
    public void handlePlayerJump(LivingEvent.LivingJumpEvent ev) {
        Vec3 newMotion;
        LivingEntity entity = ev.getEntityLiving();
        Vec3 oldMotion = entity.m_20184_();
        if (!this.sprintJumpBoost) {
            newMotion = oldMotion.m_82542_(1.0, this.launchMultiplier / 1.02040814340536, 1.0);
            AoAPackets.messagePlayer(this.getPlayer(), new UpdateClientMovementPacket(UpdateClientMovementPacket.Operation.SET).y(Float.valueOf((float)(oldMotion.m_7098_() * this.launchMultiplier / 1.02040814340536))));
        } else {
            newMotion = oldMotion.m_82542_(this.baseBoostMultiplier, 1.0, this.baseBoostMultiplier);
            AoAPackets.messagePlayer(this.getPlayer(), new UpdateClientMovementPacket(UpdateClientMovementPacket.Operation.MULTIPLY).x(Float.valueOf((float)this.baseBoostMultiplier)).z(Float.valueOf((float)this.baseBoostMultiplier)));
        }
        entity.m_20256_(newMotion);
    }

    @Override
    public void loadFromNbt(CompoundTag data) {
        super.loadFromNbt(data);
        this.updateMultipliers();
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128379_("amplify_lateral_velocity", this.sprintJumpBoost);
        }
        return data;
    }
}

