/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.resource;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;

public class EnergyResource
extends AoAResource.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.PLAYER_TICK, AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_AFTER};
    private final float maxValue;
    private final int dischargeDelay;
    private final int hitDelay;
    private final float regenAmount;
    private int currentDelay = 0;
    private float value = 0.0f;

    public EnergyResource(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoAResource)((Object)AoAResources.ENERGY.get()), plData);
        this.maxValue = Math.max(0.0f, GsonHelper.m_13915_((JsonObject)jsonData, (String)"max_value"));
        this.dischargeDelay = GsonHelper.m_13927_((JsonObject)jsonData, (String)"delay_on_empty");
        this.hitDelay = GsonHelper.m_13927_((JsonObject)jsonData, (String)"delay_on_hit");
        this.regenAmount = GsonHelper.m_13915_((JsonObject)jsonData, (String)"regen_per_tick");
    }

    public EnergyResource(CompoundTag nbtData) {
        super((AoAResource)((Object)AoAResources.ENERGY.get()), null);
        this.maxValue = nbtData.m_128457_("max_value");
        this.dischargeDelay = nbtData.m_128451_("delay_on_empty");
        this.hitDelay = nbtData.m_128451_("delay_on_hit");
        this.regenAmount = nbtData.m_128457_("regen_per_tick");
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public float getCurrentValue() {
        return this.value;
    }

    public int getCurrentDelay() {
        return this.currentDelay;
    }

    @Override
    public boolean consume(float amount, boolean consumeIfInsufficient) {
        boolean success = super.consume(amount, true);
        if (this.getCurrentValue() <= 0.0f) {
            this.currentDelay += this.dischargeDelay;
            if (this.currentDelay > 1200) {
                this.currentDelay = 1200;
            }
        }
        return success;
    }

    @Override
    public void setValue(float amount) {
        this.value = Mth.m_14036_((float)amount, (float)0.0f, (float)this.getMaxValue());
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }

    @Override
    public float getPerTickRegen() {
        return this.regenAmount;
    }

    @Override
    public void handlePlayerTick(TickEvent.PlayerTickEvent ev) {
        if (this.currentDelay > 0) {
            --this.currentDelay;
        } else if (this.value < this.getMaxValue()) {
            this.addValue(this.getPerTickRegen());
        }
    }

    @Override
    public void handlePostIncomingAttack(LivingDamageEvent ev) {
        if (ev.getAmount() > 0.0f) {
            this.currentDelay += this.hitDelay;
            if (this.currentDelay > 1200) {
                this.currentDelay = 1200;
            }
        }
    }

    @Override
    @Nonnull
    public CompoundTag saveToNbt() {
        return new CompoundTag();
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = new CompoundTag();
        if (forClientSetup) {
            data.m_128350_("max_value", this.getMaxValue());
            data.m_128405_("delay_on_empty", this.dischargeDelay);
            data.m_128405_("delay_on_hit", this.hitDelay);
            data.m_128350_("regen_per_tick", this.getPerTickRegen());
        } else {
            data.m_128350_("value", this.getCurrentValue());
            data.m_128405_("current_delay", this.getCurrentDelay());
        }
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        if (data.m_128441_("value")) {
            this.value = data.m_128457_("value");
        }
        if (data.m_128441_("current_delay")) {
            this.currentDelay = data.m_128451_("current_delay");
        }
    }
}

