/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling.sync;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;

public class UltimatumStaffTask
implements Runnable {
    private final int startingTick = GlobalEvents.tick;
    private final LivingEntity shooter;
    private final LivingEntity target;
    private final BlockPos shooterPos;
    private final BlockPos targetPos;
    private final float shooterStartHealth;
    private final float targetStartHealth;
    private boolean targetTurn = true;

    public UltimatumStaffTask(LivingEntity shooter, LivingEntity target) {
        this.shooter = shooter;
        this.target = target;
        this.shooterPos = shooter.m_142538_();
        this.targetPos = target.m_142538_();
        this.shooterStartHealth = shooter.m_21223_();
        this.targetStartHealth = target.m_21223_();
        target.m_20334_(0.0, 0.0, 0.0);
        shooter.m_20334_(0.0, 0.0, 0.0);
        EntityUtil.removePotions(target, MobEffects.f_19605_);
        EntityUtil.removePotions(shooter, MobEffects.f_19605_);
        EntityUtil.applyPotions(Arrays.asList(target, shooter), new EffectBuilder(MobEffects.f_19597_, 210).level(100).hideParticles(), new EffectBuilder(MobEffects.f_19613_, 210).level(50).hideParticles(), new EffectBuilder(MobEffects.f_19606_, 210).level(5).hideParticles(), new EffectBuilder(MobEffects.f_19611_, 510).hideParticles(), new EffectBuilder(MobEffects.f_19610_, 210).hideParticles(), new EffectBuilder(MobEffects.f_19620_, 210).level(-1).hideParticles());
    }

    @Override
    public void run() {
        if (this.shooter == null || this.target == null || this.shooter.f_19853_.f_46443_ || !this.shooter.m_142538_().equals((Object)this.shooterPos) || !this.target.m_142538_().equals((Object)this.targetPos)) {
            this.resetStates();
            return;
        }
        float healthPercent = 1.0f - (float)(GlobalEvents.tick - this.startingTick) / 200.0f;
        float targetPostHealth = this.targetStartHealth * healthPercent;
        float shooterPostHealth = this.shooterStartHealth * healthPercent;
        if (this.targetTurn) {
            if (this.target.m_21223_() == 0.0f) {
                this.resetStates();
                return;
            }
            if (targetPostHealth <= 0.0f) {
                this.resetStates();
                DamageUtil.dealMagicDamage(null, this.shooter, (Entity)this.target, this.target.m_21223_() - targetPostHealth, true);
                this.target.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.target.m_21153_(targetPostHealth);
            }
            ((ServerLevel)this.shooter.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20206_(), this.target.m_20189_(), (int)Math.ceil(10.0f * healthPercent), 0.0, 0.0, 0.0, 0.0);
        } else if (!(this.shooter instanceof Player) || !((Player)this.shooter).m_7500_()) {
            if (shooterPostHealth <= 0.0f) {
                this.resetStates();
                DamageUtil.dealSelfHarmDamage(this.shooter, this.shooter.m_21223_() - shooterPostHealth);
            } else {
                this.shooter.m_21153_(shooterPostHealth);
            }
            ((ServerLevel)this.shooter.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, this.shooter.m_20185_(), this.shooter.m_20186_() + (double)this.shooter.m_20206_(), this.shooter.m_20189_(), (int)Math.ceil(10.0f * healthPercent), 0.0, 0.0, 0.0, 0.0);
        }
        this.targetTurn = !this.targetTurn;
        AoAScheduler.scheduleSyncronisedTask(this, 1);
    }

    private void resetStates() {
        if (this.target != null && this.target.m_21223_() > 0.0f) {
            EntityUtil.removePotions(this.target, MobEffects.f_19610_, MobEffects.f_19606_, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19620_, MobEffects.f_19611_);
        }
        if (this.shooter != null && this.shooter.m_21223_() > 0.0f) {
            EntityUtil.removePotions(this.shooter, MobEffects.f_19610_, MobEffects.f_19606_, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19620_, MobEffects.f_19611_);
        }
    }
}

